/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import java.util.Objects;

public class EndpointRecord {
    private final String host;
    private final String hostAndPort;
    private final String locationDC;
    private final int port;
    private final int nodeId;

    public EndpointRecord(String host, int port, int nodeId, String locationDC) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.hostAndPort = host + ":" + port;
        this.nodeId = nodeId;
        this.locationDC = locationDC;
    }

    public EndpointRecord(String host, int port) {
        this(host, port, 0, null);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getLocation() {
        return this.locationDC;
    }

    public String toString() {
        return "Endpoint{host=" + this.host + ", port=" + this.port + ", node=" + this.nodeId + ", location=" + this.locationDC + "}";
    }
}

