/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.operation.OperationBinder;
import tech.ydb.core.utils.Async;
import tech.ydb.proto.discovery.DiscoveryProtos;
import tech.ydb.proto.discovery.v1.DiscoveryServiceGrpc;

public class YdbDiscovery {
    private static final Status EMPTY_DISCOVERY = Status.of(StatusCode.CLIENT_DISCOVERY_FAILED).withIssues(Issue.of("Discovery return empty list of endpoints", Issue.Severity.ERROR));
    private static final long DISCOVERY_PERIOD_NORMAL_SECONDS = 60L;
    private static final long DISCOVERY_PERIOD_MIN_SECONDS = 5L;
    private static final Logger logger = LoggerFactory.getLogger(YdbDiscovery.class);
    private final Handler handler;
    private final ScheduledExecutorService scheduler;
    private final String discoveryDatabase;
    private final Duration discoveryTimeout;
    private final Object readyObj = new Object();
    private volatile Instant lastUpdateTime;
    private volatile Future<?> currentSchedule = null;
    private volatile boolean isStarted = false;
    private volatile boolean isStopped = false;
    private volatile Throwable lastException = null;

    public YdbDiscovery(Handler handler, ScheduledExecutorService scheduler, String database, Duration timeout) {
        this.handler = handler;
        this.scheduler = scheduler;
        this.lastUpdateTime = handler.instant();
        this.discoveryDatabase = database;
        this.discoveryTimeout = timeout;
    }

    public void start() {
        logger.debug("start periodic discovery task");
        this.currentSchedule = this.scheduler.submit(() -> {
            logger.info("Waiting for init discovery...");
            this.runDiscovery();
        });
    }

    public void stop() {
        logger.debug("stopping PeriodicDiscoveryTask");
        this.isStopped = true;
        if (this.currentSchedule != null) {
            this.currentSchedule.cancel(false);
            this.currentSchedule = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady(long millis) throws IllegalStateException {
        if (this.isStarted) {
            return;
        }
        Object object = this.readyObj;
        synchronized (object) {
            try {
                if (this.isStarted) {
                    return;
                }
                long timeout = millis > 0L ? millis : this.discoveryTimeout.toMillis();
                this.readyObj.wait(timeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.lastException = new IllegalStateException("Discovery waiting interrupted", ex);
            }
        }
        if (!this.isStarted) {
            if (this.lastException != null) {
                throw new IllegalStateException("Discovery failed", this.lastException);
            }
            throw new IllegalStateException("Discovery is not ready");
        }
    }

    private void scheduleNextTick() {
        if (!this.isStopped) {
            logger.trace("schedule next discovery in {} seconds", (Object)5L);
            this.currentSchedule = this.scheduler.schedule(this::tick, 5L, TimeUnit.SECONDS);
        }
    }

    private void tick() {
        if (this.isStopped) {
            return;
        }
        if (this.handler.needToForceDiscovery()) {
            logger.debug("launching discovery by endpoint pessimization");
            this.runDiscovery();
        } else if (this.handler.instant().isAfter(this.lastUpdateTime.plusSeconds(60L))) {
            logger.debug("launching discovery in normal mode");
            this.runDiscovery();
        } else {
            logger.trace("no need to run discovery yet");
            this.scheduleNextTick();
        }
    }

    private void runDiscovery() {
        this.lastUpdateTime = this.handler.instant();
        GrpcTransport transport = this.handler.createDiscoveryTransport();
        try {
            logger.debug("execute list endpoints on {} with timeout {}", (Object)transport, (Object)this.discoveryTimeout);
            DiscoveryProtos.ListEndpointsRequest request = DiscoveryProtos.ListEndpointsRequest.newBuilder().setDatabase(this.discoveryDatabase).build();
            GrpcRequestSettings grpcSettings = GrpcRequestSettings.newBuilder().withDeadline(this.discoveryTimeout).build();
            ((CompletableFuture)((CompletableFuture)transport.unaryCall(DiscoveryServiceGrpc.getListEndpointsMethod(), grpcSettings, request).whenComplete((res, ex) -> transport.close())).thenApply(OperationBinder.bindSync(DiscoveryProtos.ListEndpointsResponse::getOperation, DiscoveryProtos.ListEndpointsResult.class))).whenComplete(this::handleDiscoveryResult);
        }
        catch (Throwable th) {
            transport.close();
            this.handleDiscoveryResult(null, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThrowable(Throwable th) {
        Object object = this.readyObj;
        synchronized (object) {
            this.lastException = th;
            this.scheduleNextTick();
            this.readyObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOk(String selfLocation, List<EndpointRecord> endpoints) {
        Object object = this.readyObj;
        synchronized (object) {
            this.isStarted = true;
            this.lastException = null;
            this.handler.handleEndpoints(endpoints, selfLocation).whenComplete((res, th) -> this.scheduleNextTick());
            this.readyObj.notifyAll();
        }
    }

    private void handleDiscoveryResult(Result<DiscoveryProtos.ListEndpointsResult> response, Throwable th) {
        if (th != null) {
            Throwable cause = Async.unwrapCompletionException(th);
            logger.warn("couldn't perform discovery with exception", cause);
            this.handleThrowable(cause);
            return;
        }
        try {
            DiscoveryProtos.ListEndpointsResult result = response.getValue();
            if (result.getEndpointsList().isEmpty()) {
                logger.error("discovery return empty list of endpoints");
                this.handleThrowable(new UnexpectedResultException("Discovery list is empty", EMPTY_DISCOVERY));
                return;
            }
            List<EndpointRecord> records = result.getEndpointsList().stream().map(e -> new EndpointRecord(e.getAddress(), e.getPort(), e.getNodeId(), e.getLocation())).collect(Collectors.toList());
            logger.debug("successfully received ListEndpoints result with {} endpoints", (Object)records.size());
            this.handleOk(result.getSelfLocation(), records);
        }
        catch (UnexpectedResultException ex) {
            logger.error("discovery fail {}", response);
            this.handleThrowable(ex);
        }
    }

    public static interface Handler {
        public Instant instant();

        public GrpcTransport createDiscoveryTransport();

        public boolean needToForceDiscovery();

        public CompletableFuture<Boolean> handleEndpoints(List<EndpointRecord> var1, String var2);
    }
}

