/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.settings;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import tech.ydb.core.settings.BaseRequestSettings;

public class OperationSettings
extends BaseRequestSettings {
    private final Duration operationTimeout;
    private final Duration cancelTimeout;
    private final Boolean reportCostInfo;
    private final boolean isAsyncMode;

    protected OperationSettings(OperationBuilder<?> builder) {
        super(builder);
        this.operationTimeout = ((OperationBuilder)builder).operationTimeout;
        this.cancelTimeout = ((OperationBuilder)builder).cancelTimeout;
        this.reportCostInfo = ((OperationBuilder)builder).reportCostInfo;
        this.isAsyncMode = ((OperationBuilder)builder).isAsyncMode;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public Duration getCancelTimeout() {
        return this.cancelTimeout;
    }

    public Boolean getReportCostInfo() {
        return this.reportCostInfo;
    }

    public boolean isAsyncMode() {
        return this.isAsyncMode;
    }

    public static class OperationBuilder<Self extends OperationBuilder<?>>
    extends BaseRequestSettings.BaseBuilder<Self> {
        private Duration operationTimeout = null;
        private Duration cancelTimeout = null;
        private Boolean reportCostInfo = null;
        private boolean isAsyncMode = false;

        public Self withOperationTimeout(Duration duration) {
            this.operationTimeout = duration;
            return (Self)((OperationBuilder)this.self());
        }

        public Self withOperationTimeout(long duration, TimeUnit unit) {
            this.operationTimeout = Duration.ofNanos(unit.toNanos(duration));
            return (Self)((OperationBuilder)this.self());
        }

        public Self withCancelTimeout(Duration duration) {
            this.cancelTimeout = duration;
            return (Self)((OperationBuilder)this.self());
        }

        public Self withCancelTimeout(long duration, TimeUnit unit) {
            this.cancelTimeout = Duration.ofNanos(unit.toNanos(duration));
            return (Self)((OperationBuilder)this.self());
        }

        public Self withReportCostInfo(Boolean report) {
            this.reportCostInfo = report;
            return (Self)((OperationBuilder)this.self());
        }

        public Self withAsyncMode(boolean isAsyncOperation) {
            this.isAsyncMode = isAsyncOperation;
            return (Self)((OperationBuilder)this.self());
        }

        @Override
        public OperationSettings build() {
            return new OperationSettings(this);
        }
    }
}

