/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.operation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.settings.OperationSettings;
import tech.ydb.core.utils.ProtobufUtils;
import tech.ydb.proto.OperationProtos;
import tech.ydb.proto.common.CommonProtos;

public interface Operation<T> {
    @Nullable
    public String getId();

    public boolean isReady();

    @Nullable
    public T getValue();

    public CompletableFuture<Status> cancel();

    public CompletableFuture<Status> forget();

    public CompletableFuture<Result<Boolean>> fetch();

    public <R> Operation<R> transform(Function<T, R> var1);

    public static OperationProtos.OperationParams buildParams(OperationSettings settings) {
        OperationProtos.OperationParams.Builder builder = OperationProtos.OperationParams.newBuilder();
        if (settings.getOperationTimeout() != null) {
            builder.setOperationTimeout(ProtobufUtils.durationToProto(settings.getOperationTimeout()));
        }
        if (settings.getCancelTimeout() != null) {
            builder.setCancelAfter(ProtobufUtils.durationToProto(settings.getCancelTimeout()));
        }
        if (settings.getReportCostInfo() != null) {
            if (settings.getReportCostInfo().booleanValue()) {
                builder.setReportCostInfo(CommonProtos.FeatureFlag.Status.ENABLED);
            } else {
                builder.setReportCostInfo(CommonProtos.FeatureFlag.Status.DISABLED);
            }
        }
        if (settings.isAsyncMode()) {
            builder.setOperationMode(OperationProtos.OperationParams.OperationMode.ASYNC);
        } else {
            builder.setOperationMode(OperationProtos.OperationParams.OperationMode.SYNC);
        }
        return builder.build();
    }
}

