/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.impl.call.GrpcStatusHandler;

public class UnaryCall<ReqT, RespT>
extends ClientCall.Listener<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(UnaryCall.class);
    private static final Status NO_VALUE = Status.of(StatusCode.CLIENT_INTERNAL_ERROR).withIssues(Issue.of("No value received for gRPC unary call", Issue.Severity.ERROR));
    private static final Status MULTIPLY_VALUES = Status.of(StatusCode.CLIENT_INTERNAL_ERROR).withIssues(Issue.of("More than one value received for gRPC unary call", Issue.Severity.ERROR));
    private final ClientCall<ReqT, RespT> call;
    private final GrpcStatusHandler statusConsumer;
    private final CompletableFuture<Result<RespT>> future = new CompletableFuture();
    private final AtomicReference<RespT> value = new AtomicReference();

    public UnaryCall(ClientCall<ReqT, RespT> call, GrpcStatusHandler statusConsumer) {
        this.call = call;
        this.statusConsumer = statusConsumer;
    }

    public CompletableFuture<Result<RespT>> startCall(ReqT request, Metadata headers) {
        try {
            this.call.start((ClientCall.Listener)this, headers);
            this.call.request(1);
            this.call.sendMessage(request);
            this.call.halfClose();
        }
        catch (Exception ex) {
            this.future.completeExceptionally(ex);
            try {
                this.call.cancel(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex2) {
                logger.error("Exception encountered while closing the unary call", (Throwable)ex2);
            }
        }
        return this.future;
    }

    public void onMessage(RespT value) {
        if (!this.value.compareAndSet(null, value)) {
            this.future.complete(Result.fail(MULTIPLY_VALUES));
        }
    }

    public void onClose(io.grpc.Status status, @Nullable Metadata trailers) {
        this.statusConsumer.accept(status, trailers);
        if (status.isOk()) {
            RespT snapshotValue = this.value.get();
            if (snapshotValue == null) {
                this.future.complete(Result.fail(NO_VALUE));
            } else {
                this.future.complete(Result.success(snapshotValue));
            }
        } else {
            this.future.complete(GrpcStatuses.toResult(status));
        }
    }
}

