/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;

public final class Status
implements Serializable {
    private static final long serialVersionUID = -2966026377652094862L;
    public static final Status SUCCESS = new Status(StatusCode.SUCCESS, null, Issue.EMPTY_ARRAY);
    private final StatusCode code;
    private final Double consumedRu;
    private final Issue[] issues;

    private Status(StatusCode code, Double consumedRu, Issue[] issues) {
        this.code = code;
        this.consumedRu = consumedRu;
        this.issues = issues;
    }

    public static Function<Status, CompletableFuture<Status>> compose(Supplier<CompletableFuture<Status>> supplier) {
        return status -> status.isSuccess() ? (CompletableFuture)supplier.get() : CompletableFuture.completedFuture(status);
    }

    public static <T> Function<Status, CompletableFuture<Result<T>>> composeResult(Supplier<CompletableFuture<Result<T>>> supplier) {
        return status -> status.isSuccess() ? (CompletableFuture)supplier.get() : CompletableFuture.completedFuture(Result.fail(status));
    }

    public static <T> Function<Status, CompletableFuture<Result<T>>> bindValue(T value) {
        return status -> {
            Result<Object> res = status.isSuccess() ? Result.success(value) : Result.fail(status);
            return CompletableFuture.completedFuture(res);
        };
    }

    public static Status of(StatusCode code, Double consumedRu, Issue ... issues) {
        boolean hasIssues;
        boolean bl = hasIssues = issues != null && issues.length > 0;
        if (code == StatusCode.SUCCESS && consumedRu == null && !hasIssues) {
            return SUCCESS;
        }
        return new Status(code, consumedRu, hasIssues ? issues : Issue.EMPTY_ARRAY);
    }

    public static Status of(StatusCode code) {
        if (code == StatusCode.SUCCESS) {
            return SUCCESS;
        }
        return new Status(code, null, Issue.EMPTY_ARRAY);
    }

    public Status withIssues(Issue ... newIssues) {
        if (Arrays.equals(this.issues, newIssues)) {
            return this;
        }
        return new Status(this.code, this.consumedRu, newIssues);
    }

    public Status withConsumedRu(Double newConsumedRu) {
        if (Objects.equals(this.consumedRu, newConsumedRu)) {
            return this;
        }
        return new Status(this.code, newConsumedRu, this.issues);
    }

    public boolean hasConsumedRu() {
        return this.consumedRu != null;
    }

    public Double getConsumedRu() {
        return this.consumedRu;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public Issue[] getIssues() {
        return this.issues;
    }

    public boolean isSuccess() {
        return this.code == StatusCode.SUCCESS;
    }

    public void expectSuccess(String errorMsg) throws UnexpectedResultException {
        if (!this.isSuccess()) {
            throw new UnexpectedResultException(errorMsg, this);
        }
    }

    public void expectSuccess() throws UnexpectedResultException {
        this.expectSuccess("Expected success status, but got " + (Object)((Object)this.getCode()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return this.code == status.code && Objects.equals(this.consumedRu, status.consumedRu) && Arrays.equals(this.issues, status.issues);
    }

    public int hashCode() {
        int h1 = Objects.hash(new Object[]{this.code, this.consumedRu});
        int h2 = Objects.hash(this.issues);
        return 31 * h1 + h2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Status{code = ").append((Object)this.code);
        if (this.consumedRu != null) {
            sb.append(", consumed RU = ").append(this.consumedRu);
        }
        if (this.issues != null && this.issues.length > 0) {
            sb.append(", issues = ").append(Arrays.toString(this.issues));
        }
        return sb.append("}").toString();
    }
}

