/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.ManagedChannelFactory;

public class GrpcChannel {
    private static final long WAIT_FOR_CLOSING_MS = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(GrpcChannel.class);
    private final EndpointRecord endpoint;
    private final ManagedChannel channel;
    private final long connectTimeoutMs;
    private final ReadyWatcher readyWatcher;

    public GrpcChannel(EndpointRecord endpoint, ManagedChannelFactory factory) {
        logger.debug("Creating grpc channel with {}", (Object)endpoint);
        this.endpoint = endpoint;
        this.channel = factory.newManagedChannel(endpoint.getHost(), endpoint.getPort());
        this.connectTimeoutMs = factory.getConnectTimeoutMs();
        this.readyWatcher = new ReadyWatcher();
        this.readyWatcher.checkState();
    }

    public EndpointRecord getEndpoint() {
        return this.endpoint;
    }

    public Channel getReadyChannel() {
        return this.readyWatcher.getReadyChannel();
    }

    public boolean isShutdown() {
        return this.channel.isShutdown();
    }

    public boolean shutdown() {
        if (this.isShutdown()) {
            return true;
        }
        try {
            boolean closed = this.channel.shutdown().awaitTermination(1000L, TimeUnit.MILLISECONDS);
            if (closed) {
                logger.debug("Grpc channel {} shutdown successfully", (Object)this.endpoint);
            } else {
                logger.warn("Grpc channel {} shutdown timeout exceeded", (Object)this.endpoint);
            }
            boolean bl = closed;
            return bl;
        }
        catch (InterruptedException e) {
            logger.warn("transport shutdown interrupted for channel {}: ", (Object)this.endpoint, (Object)e);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.channel.shutdownNow();
        }
    }

    private class ReadyWatcher
    implements Runnable {
        private final CompletableFuture<ManagedChannel> future = new CompletableFuture();

        private ReadyWatcher() {
        }

        public Channel getReadyChannel() {
            try {
                return (Channel)this.future.get(GrpcChannel.this.connectTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                logger.error("Grpc channel {} ready waiting is interrupted: ", (Object)GrpcChannel.this.endpoint, (Object)ex);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                logger.error("Grpc channel {} connecting problem: ", (Object)GrpcChannel.this.endpoint, (Object)ex);
                throw new RuntimeException("Channel " + GrpcChannel.this.endpoint + " connecting problem", ex);
            }
            catch (TimeoutException ex) {
                logger.error("Grpc channel {} connect timeout exceeded", (Object)GrpcChannel.this.endpoint);
                throw new RuntimeException("Channel " + GrpcChannel.this.endpoint + " connecting timeout");
            }
            return null;
        }

        public void checkState() {
            ConnectivityState state = GrpcChannel.this.channel.getState(true);
            logger.debug("Grpc channel {} new state: {}", (Object)GrpcChannel.this.endpoint, (Object)state);
            switch (state) {
                case READY: {
                    this.future.complete(GrpcChannel.this.channel);
                    GrpcChannel.this.channel.notifyWhenStateChanged(state, (Runnable)this);
                    break;
                }
                case SHUTDOWN: {
                    this.future.completeExceptionally(new IllegalStateException("Grpc channel already closed"));
                    break;
                }
                default: {
                    GrpcChannel.this.channel.notifyWhenStateChanged(state, (Runnable)this);
                }
            }
        }

        @Override
        public void run() {
            this.checkState();
        }
    }
}

