/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.grpc.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.FixedCallOptionsTransport;
import tech.ydb.core.impl.YdbDiscovery;
import tech.ydb.core.impl.YdbSchedulerFactory;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.pool.EndpointPool;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.core.impl.pool.GrpcChannelPool;
import tech.ydb.core.impl.pool.ManagedChannelFactory;

public class YdbTransportImpl
extends BaseGrpcTransport {
    static final int DEFAULT_PORT = 2135;
    private static final Logger logger = LoggerFactory.getLogger(YdbTransportImpl.class);
    private final String database;
    private final EndpointRecord discoveryEndpoint;
    private final ScheduledExecutorService scheduler;
    private final ManagedChannelFactory channelFactory;
    private final AuthCallOptions callOptions;
    private final EndpointPool endpointPool;
    private final GrpcChannelPool channelPool;
    private final YdbDiscovery discovery;

    public YdbTransportImpl(GrpcTransportBuilder builder) {
        BalancingSettings balancingSettings = YdbTransportImpl.getBalancingSettings(builder);
        Duration discoveryTimeout = Duration.ofMillis(builder.getDiscoveryTimeoutMillis());
        this.database = Strings.nullToEmpty((String)builder.getDatabase());
        this.discoveryEndpoint = YdbTransportImpl.getDiscoveryEndpoint(builder);
        logger.info("Create YDB transport with endpoint {} and {}", (Object)this.discoveryEndpoint, (Object)balancingSettings);
        this.channelFactory = builder.getManagedChannelFactory();
        this.scheduler = builder.getSchedulerFactory().get();
        this.callOptions = new AuthCallOptions(this.scheduler, Arrays.asList(this.discoveryEndpoint), this.channelFactory, builder);
        this.channelPool = new GrpcChannelPool(this.channelFactory, this.scheduler);
        this.endpointPool = new EndpointPool(balancingSettings);
        this.discovery = new YdbDiscovery(new DiscoveryHandler(), this.scheduler, this.database, discoveryTimeout);
    }

    public void start(GrpcTransportBuilder.InitMode mode) {
        if (mode == GrpcTransportBuilder.InitMode.ASYNC_FALLBACK) {
            this.endpointPool.setNewState(null, Collections.singletonList(this.discoveryEndpoint));
        }
        this.discovery.start();
        if (mode == GrpcTransportBuilder.InitMode.SYNC) {
            this.discovery.waitReady(-1L);
        }
    }

    public String toString() {
        return "YdbTransport{endpoint=" + this.discoveryEndpoint + ", database=" + this.database + "}";
    }

    @Deprecated
    public void startAsync(Runnable readyWatcher) {
        this.endpointPool.setNewState(null, Collections.singletonList(this.discoveryEndpoint));
        this.discovery.start();
        if (readyWatcher != null) {
            this.scheduler.execute(() -> {
                this.discovery.waitReady(-1L);
                readyWatcher.run();
            });
        }
    }

    @Override
    protected void shutdown() {
        this.discovery.stop();
        this.channelPool.shutdown();
        this.callOptions.close();
        YdbSchedulerFactory.shutdownScheduler(this.scheduler);
    }

    static EndpointRecord getDiscoveryEndpoint(GrpcTransportBuilder builder) {
        URI endpointURI = null;
        try {
            HostAndPort host;
            String endpoint = builder.getEndpoint();
            if (endpoint != null) {
                endpointURI = endpoint.startsWith("grpc://") || endpoint.startsWith("grpcs://") ? new URI(endpoint) : new URI(null, endpoint, null, null, null);
            }
            if ((host = builder.getHost()) != null) {
                endpointURI = new URI(null, null, host.getHost(), host.getPortOrDefault(2135), null, null, null);
            }
        }
        catch (URISyntaxException ex) {
            logger.warn("endpoint parse problem", (Throwable)ex);
        }
        if (endpointURI == null) {
            throw new IllegalArgumentException("Can't create discovery rpc, unreadable endpoint " + builder.getEndpoint() + " and empty host " + builder.getHost());
        }
        return new EndpointRecord(endpointURI.getHost(), endpointURI.getPort());
    }

    private static BalancingSettings getBalancingSettings(GrpcTransportBuilder builder) {
        BalancingSettings balancingSettings = builder.getBalancingSettings();
        if (balancingSettings != null) {
            return balancingSettings;
        }
        String localDc = builder.getLocalDc();
        if (localDc != null) {
            return BalancingSettings.fromLocation(builder.getLocalDc());
        }
        return BalancingSettings.defaultInstance();
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public AuthCallOptions getAuthCallOptions() {
        return this.callOptions;
    }

    @Override
    protected GrpcChannel getChannel(GrpcRequestSettings settings) {
        EndpointRecord endpoint = this.endpointPool.getEndpoint(settings.getPreferredNodeID());
        if (endpoint == null) {
            long timeout = -1L;
            if (settings.getDeadlineAfter() != 0L) {
                timeout = settings.getDeadlineAfter() - System.nanoTime();
            }
            this.discovery.waitReady(timeout);
            endpoint = this.endpointPool.getEndpoint(settings.getPreferredNodeID());
        }
        return this.channelPool.getChannel(endpoint);
    }

    @Override
    protected void updateChannelStatus(GrpcChannel channel, Status status) {
        if (!status.isOk() && status.getCode() != Status.Code.CANCELLED) {
            this.endpointPool.pessimizeEndpoint(channel.getEndpoint());
        }
    }

    private class DiscoveryHandler
    implements YdbDiscovery.Handler {
        private DiscoveryHandler() {
        }

        @Override
        public Instant instant() {
            return Instant.now();
        }

        @Override
        public boolean needToForceDiscovery() {
            return YdbTransportImpl.this.endpointPool.needToRunDiscovery();
        }

        @Override
        public CompletableFuture<Boolean> handleEndpoints(List<EndpointRecord> endpoints, String selfLocation) {
            List<EndpointRecord> removed = YdbTransportImpl.this.endpointPool.setNewState(selfLocation, endpoints);
            return YdbTransportImpl.this.channelPool.removeChannels(removed);
        }

        @Override
        public GrpcTransport createDiscoveryTransport() {
            return new FixedCallOptionsTransport(YdbTransportImpl.this.scheduler, YdbTransportImpl.this.callOptions, YdbTransportImpl.this.database, YdbTransportImpl.this.discoveryEndpoint, YdbTransportImpl.this.channelFactory);
        }
    }
}

