/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.operation;

import java.util.List;
import java.util.function.Function;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.proto.StatusCodesProtos;
import tech.ydb.proto.YdbIssueMessage;

public class StatusMapper<R>
implements Function<Result<R>, Status> {
    private final Function<R, StatusCodesProtos.StatusIds.StatusCode> statusMethod;
    private final Function<R, List<YdbIssueMessage.IssueMessage>> issuesMethod;

    private StatusMapper(Function<R, StatusCodesProtos.StatusIds.StatusCode> status, Function<R, List<YdbIssueMessage.IssueMessage>> issues) {
        this.statusMethod = status;
        this.issuesMethod = issues;
    }

    @Override
    public Status apply(Result<R> result) {
        if (!result.isSuccess()) {
            return result.getStatus();
        }
        R resp = result.getValue();
        return Status.of(StatusCode.fromProto(this.statusMethod.apply(resp)), result.getStatus().getConsumedRu(), Issue.fromPb(this.issuesMethod.apply(resp)));
    }

    public static <T> StatusMapper<T> of(Function<T, StatusCodesProtos.StatusIds.StatusCode> statusMethod, Function<T, List<YdbIssueMessage.IssueMessage>> issuesMethod) {
        return new StatusMapper<T>(statusMethod, issuesMethod);
    }
}

