/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.grpc.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.YdbSchedulerFactory;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.discovery.GrpcDiscoveryRpc;
import tech.ydb.core.impl.discovery.PeriodicDiscoveryTask;
import tech.ydb.core.impl.pool.EndpointPool;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.core.impl.pool.GrpcChannelPool;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.proto.discovery.DiscoveryProtos;

public class YdbTransportImpl
extends BaseGrpcTransport {
    static final int DEFAULT_PORT = 2135;
    private static final Logger logger = LoggerFactory.getLogger(YdbTransportImpl.class);
    private final AuthCallOptions callOptions;
    private final String database;
    private final EndpointPool endpointPool;
    private final GrpcChannelPool channelPool;
    private final PeriodicDiscoveryTask periodicDiscoveryTask;
    private final ScheduledExecutorService scheduler;

    public YdbTransportImpl(GrpcTransportBuilder builder) {
        this.database = Strings.nullToEmpty((String)builder.getDatabase());
        ManagedChannelFactory channelFactory = builder.getManagedChannelFactory();
        BalancingSettings balancingSettings = YdbTransportImpl.getBalancingSettings(builder);
        EndpointRecord discoveryEndpoint = YdbTransportImpl.getDiscoveryEndpoint(builder);
        logger.info("Create YDB transport with endpoint {} and {}", (Object)discoveryEndpoint, (Object)balancingSettings);
        this.scheduler = builder.getSchedulerFactory().get();
        this.callOptions = new AuthCallOptions(this.scheduler, this.database, Collections.singletonList(discoveryEndpoint), channelFactory, builder);
        GrpcDiscoveryRpc discoveryRpc = new GrpcDiscoveryRpc(this, discoveryEndpoint, channelFactory, this.callOptions, Duration.ofMillis(builder.getDiscoveryTimeoutMillis()));
        this.channelPool = new GrpcChannelPool(channelFactory, this.scheduler);
        this.endpointPool = new EndpointPool(discoveryEndpoint, balancingSettings);
        this.periodicDiscoveryTask = new PeriodicDiscoveryTask(this.scheduler, discoveryRpc, new YdbDiscoveryHandler(), builder.getConnectTimeoutMillis() + builder.getDiscoveryTimeoutMillis());
    }

    public void init() {
        this.periodicDiscoveryTask.start();
    }

    public void initAsync(Runnable readyWatcher) {
        this.periodicDiscoveryTask.startAsync(readyWatcher);
    }

    static EndpointRecord getDiscoveryEndpoint(GrpcTransportBuilder builder) {
        URI endpointURI = null;
        try {
            HostAndPort host;
            String endpoint = builder.getEndpoint();
            if (endpoint != null) {
                endpointURI = endpoint.startsWith("grpc://") || endpoint.startsWith("grpcs://") ? new URI(endpoint) : new URI(null, endpoint, null, null, null);
            }
            if ((host = builder.getHost()) != null) {
                endpointURI = new URI(null, null, host.getHost(), host.getPortOrDefault(2135), null, null, null);
            }
        }
        catch (URISyntaxException ex) {
            logger.warn("endpoint parse problem", (Throwable)ex);
        }
        if (endpointURI == null) {
            throw new IllegalArgumentException("Can't create discovery rpc, unreadable endpoint " + builder.getEndpoint() + " and empty host " + builder.getHost());
        }
        return new EndpointRecord(endpointURI.getHost(), endpointURI.getPort(), 0);
    }

    private static BalancingSettings getBalancingSettings(GrpcTransportBuilder builder) {
        BalancingSettings balancingSettings = builder.getBalancingSettings();
        if (balancingSettings != null) {
            return balancingSettings;
        }
        String localDc = builder.getLocalDc();
        if (localDc != null) {
            return BalancingSettings.fromLocation(builder.getLocalDc());
        }
        return BalancingSettings.defaultInstance();
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        if (this.shutdown) {
            return;
        }
        super.close();
        this.periodicDiscoveryTask.stop();
        this.channelPool.shutdown();
        this.callOptions.close();
        YdbSchedulerFactory.shutdownScheduler(this.scheduler);
    }

    @Override
    public AuthCallOptions getAuthCallOptions() {
        return this.callOptions;
    }

    @Override
    protected GrpcChannel getChannel(GrpcRequestSettings settings) {
        EndpointRecord endpoint = this.endpointPool.getEndpoint(settings.getPreferredNodeID());
        return this.channelPool.getChannel(endpoint);
    }

    @Override
    void updateChannelStatus(GrpcChannel channel, Status status) {
        if (!status.isOk() && status.getCode() != Status.Code.CANCELLED) {
            this.endpointPool.pessimizeEndpoint(channel.getEndpoint());
        }
    }

    private class YdbDiscoveryHandler
    implements PeriodicDiscoveryTask.DiscoveryHandler {
        private YdbDiscoveryHandler() {
        }

        @Override
        public boolean useMinDiscoveryPeriod() {
            return YdbTransportImpl.this.endpointPool.needToRunDiscovery();
        }

        @Override
        public void handleDiscoveryResult(DiscoveryProtos.ListEndpointsResult result) {
            List<EndpointRecord> removed = YdbTransportImpl.this.endpointPool.setNewState(result);
            YdbTransportImpl.this.channelPool.removeChannels(removed);
        }
    }
}

