/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.YdbSchedulerFactory;
import tech.ydb.core.impl.YdbTransportImpl;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.pool.EndpointPool;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.core.impl.pool.GrpcChannelPool;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.proto.discovery.DiscoveryProtos;

@Deprecated
public class MultiChannelTransport
extends BaseGrpcTransport {
    private static final Logger logger = LoggerFactory.getLogger(YdbTransportImpl.class);
    private final String database;
    private final AuthCallOptions callOptions;
    private final DiscoveryProtos.ListEndpointsResult discoveryResult;
    private final EndpointPool endpointPool;
    private final GrpcChannelPool channelPool;
    private final ScheduledExecutorService scheduler;

    public MultiChannelTransport(GrpcTransportBuilder builder, List<HostAndPort> hosts) {
        ManagedChannelFactory channelFactory = builder.getManagedChannelFactory();
        logger.info("creating multi channel transport with hosts {}", Objects.requireNonNull(hosts));
        this.database = Strings.nullToEmpty((String)builder.getDatabase());
        this.scheduler = builder.getSchedulerFactory().get();
        ArrayList<EndpointRecord> endpoints = new ArrayList<EndpointRecord>();
        DiscoveryProtos.ListEndpointsResult.Builder discoveryBuilder = DiscoveryProtos.ListEndpointsResult.newBuilder();
        hosts.forEach(host -> {
            endpoints.add(new EndpointRecord(host.getHost(), host.getPortOrDefault(2135), 0));
            discoveryBuilder.addEndpointsBuilder().setAddress(host.getHost()).setPort(host.getPortOrDefault(2135)).build();
        });
        this.discoveryResult = discoveryBuilder.build();
        this.callOptions = new AuthCallOptions(this.scheduler, this.database, endpoints, channelFactory, builder);
        this.channelPool = new GrpcChannelPool(channelFactory, this.scheduler);
        this.endpointPool = new EndpointPool(null, BalancingSettings.defaultInstance());
        this.endpointPool.setNewState(this.discoveryResult);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        super.close();
        this.channelPool.shutdown();
        this.callOptions.close();
        YdbSchedulerFactory.shutdownScheduler(this.scheduler);
    }

    @Override
    public AuthCallOptions getAuthCallOptions() {
        return this.callOptions;
    }

    @Override
    protected GrpcChannel getChannel(GrpcRequestSettings settings) {
        EndpointRecord endpoint = this.endpointPool.getEndpoint(null);
        return this.channelPool.getChannel(endpoint);
    }

    @Override
    void updateChannelStatus(GrpcChannel channel, Status status) {
        if (!status.isOk()) {
            this.endpointPool.pessimizeEndpoint(channel.getEndpoint());
            if (this.endpointPool.needToRunDiscovery()) {
                this.endpointPool.setNewState(this.discoveryResult);
            }
        }
    }
}

