/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.auth;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.auth.AuthIdentity;

class YdbCallCredentials
extends CallCredentials {
    static final Metadata.Key<String> AUTH_TICKET = Metadata.Key.of((String)"x-ydb-auth-ticket", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Logger logger = LoggerFactory.getLogger(YdbCallCredentials.class);
    private final AuthIdentity identity;

    YdbCallCredentials(AuthIdentity identity) {
        this.identity = identity;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        try {
            Metadata headers = new Metadata();
            String token = this.identity.getToken();
            if (token != null) {
                headers.put(AUTH_TICKET, (Object)token);
            }
            applier.apply(headers);
        }
        catch (Exception ex) {
            logger.error("unexpected exception ", (Throwable)ex);
            applier.fail(Status.INTERNAL.withDescription("get token exception").withCause((Throwable)ex));
        }
    }

    public void thisUsesUnstableApi() {
    }
}

