/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.auth;

import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import tech.ydb.auth.AuthIdentity;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.core.grpc.GrpcCompression;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.auth.GrpcAuthRpc;
import tech.ydb.core.impl.auth.YdbCallCredentials;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.ManagedChannelFactory;

public class AuthCallOptions
implements AutoCloseable {
    private final AuthIdentity authIdentity;
    private final CallOptions callOptions;
    private final long readTimeoutMillis;

    public AuthCallOptions() {
        this.authIdentity = null;
        this.callOptions = CallOptions.DEFAULT;
        this.readTimeoutMillis = 0L;
    }

    public AuthCallOptions(BaseGrpcTransport parent, List<EndpointRecord> endpoints, ManagedChannelFactory channelFactory, AuthRpcProvider<? super GrpcAuthRpc> authProvider, long readTimeoutMillis, Executor callExecutor, GrpcCompression compression) {
        CallOptions options = CallOptions.DEFAULT;
        if (authProvider != null) {
            GrpcAuthRpc rpc = new GrpcAuthRpc(endpoints, parent, channelFactory);
            this.authIdentity = authProvider.createAuthIdentity((Object)rpc);
        } else {
            this.authIdentity = null;
        }
        if (this.authIdentity != null) {
            options = options.withCallCredentials((CallCredentials)new YdbCallCredentials(this.authIdentity));
        }
        if (callExecutor != null && callExecutor != MoreExecutors.directExecutor()) {
            options = options.withExecutor(callExecutor);
        }
        if (compression != GrpcCompression.NO_COMPRESSION) {
            options = options.withCompression(compression.compressor());
        }
        this.callOptions = options;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    public void close() {
        if (this.authIdentity != null) {
            this.authIdentity.close();
        }
    }

    public String getToken() {
        if (this.authIdentity != null) {
            return this.authIdentity.getToken();
        }
        return null;
    }

    public CallOptions getGrpcCallOptions() {
        if (this.readTimeoutMillis > 0L) {
            return this.callOptions.withDeadlineAfter(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return this.callOptions;
    }
}

