/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core;

import java.util.EnumSet;
import tech.ydb.proto.StatusCodesProtos;

public enum StatusCode {
    UNUSED_STATUS(0),
    SUCCESS(400000),
    BAD_REQUEST(400010),
    UNAUTHORIZED(400020),
    INTERNAL_ERROR(400030),
    ABORTED(400040),
    UNAVAILABLE(400050),
    OVERLOADED(400060),
    SCHEME_ERROR(400070),
    GENERIC_ERROR(400080),
    TIMEOUT(400090),
    BAD_SESSION(400100),
    PRECONDITION_FAILED(400120),
    ALREADY_EXISTS(400130),
    NOT_FOUND(400140),
    SESSION_EXPIRED(400150),
    CANCELLED(400160),
    UNDETERMINED(400170),
    UNSUPPORTED(400180),
    SESSION_BUSY(400190),
    TRANSPORT_UNAVAILABLE(401010),
    CLIENT_RESOURCE_EXHAUSTED(401020),
    CLIENT_DEADLINE_EXCEEDED(401030),
    CLIENT_INTERNAL_ERROR(401050),
    CLIENT_CANCELLED(401060),
    CLIENT_UNAUTHENTICATED(401070),
    CLIENT_CALL_UNIMPLEMENTED(401080),
    CLIENT_DISCOVERY_FAILED(402010),
    CLIENT_LIMITS_REACHED(402020),
    CLIENT_DEADLINE_EXPIRED(402030);

    private static final EnumSet<StatusCode> RETRYABLE_STATUSES;
    private static final EnumSet<StatusCode> IDEMPOTENT_RETRYABLE_STATUSES;
    private final int code;

    private StatusCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isTransportError() {
        return this.code >= 401000 && this.code <= 401999;
    }

    public boolean isRetryable(boolean isOperationIdempotent, boolean retryNotFound) {
        if (RETRYABLE_STATUSES.contains((Object)this)) {
            return true;
        }
        switch (this) {
            case NOT_FOUND: {
                return retryNotFound;
            }
            case CLIENT_CANCELLED: 
            case CLIENT_INTERNAL_ERROR: 
            case UNDETERMINED: 
            case TRANSPORT_UNAVAILABLE: {
                return isOperationIdempotent;
            }
        }
        return false;
    }

    public static StatusCode fromProto(StatusCodesProtos.StatusIds.StatusCode code) {
        switch (code) {
            case SUCCESS: {
                return SUCCESS;
            }
            case BAD_REQUEST: {
                return BAD_REQUEST;
            }
            case UNAUTHORIZED: {
                return UNAUTHORIZED;
            }
            case INTERNAL_ERROR: {
                return INTERNAL_ERROR;
            }
            case ABORTED: {
                return ABORTED;
            }
            case UNAVAILABLE: {
                return UNAVAILABLE;
            }
            case OVERLOADED: {
                return OVERLOADED;
            }
            case SCHEME_ERROR: {
                return SCHEME_ERROR;
            }
            case GENERIC_ERROR: {
                return GENERIC_ERROR;
            }
            case TIMEOUT: {
                return TIMEOUT;
            }
            case BAD_SESSION: {
                return BAD_SESSION;
            }
            case PRECONDITION_FAILED: {
                return PRECONDITION_FAILED;
            }
            case ALREADY_EXISTS: {
                return ALREADY_EXISTS;
            }
            case NOT_FOUND: {
                return NOT_FOUND;
            }
            case SESSION_EXPIRED: {
                return SESSION_EXPIRED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case UNDETERMINED: {
                return UNDETERMINED;
            }
            case UNSUPPORTED: {
                return UNSUPPORTED;
            }
            case SESSION_BUSY: {
                return SESSION_BUSY;
            }
        }
        return UNUSED_STATUS;
    }

    public boolean isRetryable(boolean idempotent) {
        return RETRYABLE_STATUSES.contains((Object)this) || idempotent && IDEMPOTENT_RETRYABLE_STATUSES.contains((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        if (this != SUCCESS) {
            sb = sb.append("(code=").append(this.code).append(")");
        }
        return sb.toString();
    }

    static {
        RETRYABLE_STATUSES = EnumSet.of(ABORTED, new StatusCode[]{UNAVAILABLE, OVERLOADED, CLIENT_RESOURCE_EXHAUSTED, BAD_SESSION, SESSION_BUSY});
        IDEMPOTENT_RETRYABLE_STATUSES = EnumSet.of(CLIENT_CANCELLED, CLIENT_INTERNAL_ERROR, UNDETERMINED, TRANSPORT_UNAVAILABLE);
    }
}

