/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.auth;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.FixedCallOptionsTransport;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.ManagedChannelFactory;

public class GrpcAuthRpc {
    private final List<EndpointRecord> endpoints;
    private final BaseGrpcTransport parent;
    private final ManagedChannelFactory channelFactory;
    private final AtomicInteger endpointIdx = new AtomicInteger(0);

    public GrpcAuthRpc(List<EndpointRecord> endpoints, BaseGrpcTransport parent, ManagedChannelFactory channelFactory) {
        if (endpoints == null || endpoints.isEmpty()) {
            throw new IllegalStateException("Empty endpoints list for auth rpc");
        }
        this.endpoints = endpoints;
        this.parent = parent;
        this.channelFactory = channelFactory;
    }

    public ExecutorService getExecutor() {
        return this.parent.getScheduler();
    }

    public String getDatabase() {
        return this.parent.getDatabase();
    }

    public void changeEndpoint() {
        int next;
        int cur;
        while (!this.endpointIdx.compareAndSet(cur = this.endpointIdx.get(), next = (cur + 1) % this.endpoints.size())) {
        }
    }

    public GrpcTransport createTransport() {
        return new FixedCallOptionsTransport(this.parent.getScheduler(), new AuthCallOptions(), this.parent.getDatabase(), this.endpoints.get(this.endpointIdx.get()), this.channelFactory);
    }
}

