/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.discovery;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Operations;
import tech.ydb.core.Result;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.FixedCallOptionsTransport;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.proto.discovery.DiscoveryProtos;
import tech.ydb.proto.discovery.v1.DiscoveryServiceGrpc;

public class GrpcDiscoveryRpc {
    private static final Logger logger = LoggerFactory.getLogger(GrpcDiscoveryRpc.class);
    private final BaseGrpcTransport parent;
    private final EndpointRecord endpoint;
    private final ManagedChannelFactory channelFactory;
    private final AuthCallOptions callOptions;
    private final Duration discoveryTimeout;

    public GrpcDiscoveryRpc(BaseGrpcTransport parent, EndpointRecord endpoint, ManagedChannelFactory channelFactory, AuthCallOptions callOptions, Duration discoveryTimeout) {
        this.parent = parent;
        this.endpoint = endpoint;
        this.channelFactory = channelFactory;
        this.callOptions = callOptions;
        this.discoveryTimeout = discoveryTimeout;
    }

    public CompletableFuture<Result<DiscoveryProtos.ListEndpointsResult>> listEndpoints() {
        GrpcTransport transport = this.createTransport();
        logger.debug("list endpoints from {} with timeout {}", (Object)this.endpoint.getHostAndPort(), (Object)this.discoveryTimeout);
        DiscoveryProtos.ListEndpointsRequest request = DiscoveryProtos.ListEndpointsRequest.newBuilder().setDatabase(this.parent.getDatabase()).build();
        GrpcRequestSettings grpcSettings = GrpcRequestSettings.newBuilder().withDeadline(this.discoveryTimeout).build();
        return ((CompletableFuture)transport.unaryCall(DiscoveryServiceGrpc.getListEndpointsMethod(), grpcSettings, request).whenComplete((res, ex) -> transport.close())).thenApply(Operations.resultUnwrapper(DiscoveryProtos.ListEndpointsResponse::getOperation, DiscoveryProtos.ListEndpointsResult.class));
    }

    private GrpcTransport createTransport() {
        return new FixedCallOptionsTransport(this.parent.getScheduler(), this.callOptions, this.parent.getDatabase(), this.endpoint, this.channelFactory);
    }
}

