/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.grpc;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.grpc.MethodDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ydb.core.Result;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.utils.URITools;

public interface GrpcTransport
extends AutoCloseable {
    public <ReqT, RespT> CompletableFuture<Result<RespT>> unaryCall(MethodDescriptor<ReqT, RespT> var1, GrpcRequestSettings var2, ReqT var3);

    public <ReqT, RespT> GrpcReadStream<RespT> readStreamCall(MethodDescriptor<ReqT, RespT> var1, GrpcRequestSettings var2, ReqT var3);

    public <ReqT, RespT> GrpcReadWriteStream<RespT, ReqT> readWriteStreamCall(MethodDescriptor<ReqT, RespT> var1, GrpcRequestSettings var2);

    public String getDatabase();

    public ScheduledExecutorService getScheduler();

    @Override
    public void close();

    public static GrpcTransportBuilder forHost(HostAndPort hostAndPort, String database) {
        return new GrpcTransportBuilder(null, hostAndPort, database);
    }

    public static GrpcTransportBuilder forHost(String host, int port, String database) {
        return new GrpcTransportBuilder(null, HostAndPort.fromParts((String)host, (int)port), database);
    }

    public static GrpcTransportBuilder forEndpoint(String endpoint, String database) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint is null");
        Preconditions.checkNotNull((Object)database, (Object)"database is null");
        return new GrpcTransportBuilder(endpoint, null, database);
    }

    public static GrpcTransportBuilder forConnectionString(String connectionString) {
        String scheme;
        String database;
        String endpoint;
        Preconditions.checkNotNull((Object)connectionString, (Object)"connection string is null");
        try {
            URI uri = new URI(connectionString.contains("://") ? connectionString : "grpc://" + connectionString);
            endpoint = uri.getAuthority();
            Preconditions.checkNotNull((Object)endpoint, (Object)"no endpoint in connection string");
            database = uri.getPath();
            Map<String, List<String>> params = URITools.splitQuery(uri);
            List<String> databaseList = params.get("database");
            if (databaseList != null && !databaseList.isEmpty()) {
                database = databaseList.get(0);
            }
            Preconditions.checkArgument((database != null && !database.isEmpty() ? 1 : 0) != 0, (Object)"no database in connection string");
            scheme = uri.getScheme();
        }
        catch (RuntimeException | URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse connection string '" + connectionString + "'. Expected format: [<protocol>://]<host>[:<port>]/?database=<database-path>", e);
        }
        GrpcTransportBuilder builder = new GrpcTransportBuilder(endpoint, null, database);
        if (scheme.equals("grpcs")) {
            builder.withSecureConnection();
        } else if (!scheme.equals("grpc")) {
            throw new IllegalArgumentException("Unknown protocol '" + scheme + "' in connection string");
        }
        return builder;
    }
}

