/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.settings;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class BaseRequestSettings {
    private final String traceId;
    private final Duration requestTimeout;

    protected BaseRequestSettings(BaseBuilder<?> builder) {
        this.traceId = ((BaseBuilder)builder).traceId;
        this.requestTimeout = ((BaseBuilder)builder).requestTimeout;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public static class BaseBuilder<Self extends BaseBuilder<?>> {
        private String traceId = null;
        private Duration requestTimeout = null;

        protected Self self() {
            return (Self)this;
        }

        public Self withRequestTimeout(Duration duration) {
            this.requestTimeout = duration;
            return this.self();
        }

        public Self withRequestTimeout(long duration, TimeUnit unit) {
            this.requestTimeout = Duration.ofNanos(unit.toNanos(duration));
            return this.self();
        }

        public BaseRequestSettings build() {
            return new BaseRequestSettings(this);
        }
    }
}

