/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import com.google.common.base.Strings;
import io.grpc.Status;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.YdbSchedulerFactory;
import tech.ydb.core.impl.YdbTransportImpl;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.core.impl.pool.ManagedChannelFactory;

public class SingleChannelTransport
extends BaseGrpcTransport {
    private static final Logger logger = LoggerFactory.getLogger(SingleChannelTransport.class);
    private final AuthCallOptions callOptions;
    private final GrpcChannel channel;
    private final String database;
    private final ScheduledExecutorService scheduler;

    public SingleChannelTransport(GrpcTransportBuilder builder) {
        ManagedChannelFactory channelFactory = ManagedChannelFactory.fromBuilder(builder);
        EndpointRecord endpoint = YdbTransportImpl.getDiscoveryEndpoint(builder);
        logger.info("creating signle channel transport with endpoint {}", (Object)endpoint);
        this.database = Strings.nullToEmpty((String)builder.getDatabase());
        this.channel = new GrpcChannel(endpoint, channelFactory, true);
        this.callOptions = new AuthCallOptions(this, Collections.singletonList(endpoint), channelFactory, builder.getAuthProvider(), builder.getReadTimeoutMillis(), builder.getCallExecutor(), builder.getGrpcCompression());
        this.scheduler = builder.getSchedulerFactory().get();
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        super.close();
        this.channel.shutdown();
        this.callOptions.close();
        YdbSchedulerFactory.shutdownScheduler(this.scheduler);
    }

    @Override
    public AuthCallOptions getAuthCallOptions() {
        return this.callOptions;
    }

    @Override
    GrpcChannel getChannel(GrpcRequestSettings settings) {
        return this.channel;
    }

    @Override
    void updateChannelStatus(GrpcChannel channel, Status status) {
        if (!status.isOk()) {
            logger.warn("grpc error {}[{}] on single channel {}", new Object[]{status.getCode(), status.getDescription(), channel.getEndpoint()});
        }
    }
}

