/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.settings;

import java.time.Duration;
import java.util.concurrent.Executor;
import tech.ydb.common.retry.RetryPolicy;
import tech.ydb.common.retry.RetryUntilElapsed;

public class CoordinationSessionSettings {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    public static final RetryUntilElapsed DEFAULT_RETRY_POLICY = new RetryUntilElapsed(DEFAULT_CONNECT_TIMEOUT.toMillis(), 250L, 5);
    private final Executor executor;
    private final Duration connectTimeout;
    private final RetryPolicy retryPolicy;

    private CoordinationSessionSettings(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.executor = builder.executor;
        this.retryPolicy = builder.retryPolicy;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Executor executor = null;
        private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;

        public Builder withExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withConnectTimeout(Duration timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public CoordinationSessionSettings build() {
            return new CoordinationSessionSettings(this);
        }
    }
}

