/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.description;

import com.google.common.base.Preconditions;
import java.time.Duration;
import tech.ydb.proto.coordination.Config;
import tech.ydb.proto.coordination.DescribeNodeResult;

public class NodeConfig {
    private final Duration selfCheckPeriod;
    private final Duration sessionGracePeriod;
    private final ConsistencyMode readConsistencyMode;
    private final ConsistencyMode attachConsistencyMode;
    private final RateLimiterCountersMode rateLimiterCountersMode;

    private NodeConfig() {
        this.selfCheckPeriod = Duration.ofSeconds(1L);
        this.sessionGracePeriod = Duration.ofSeconds(10L);
        this.readConsistencyMode = ConsistencyMode.UNSET;
        this.attachConsistencyMode = ConsistencyMode.UNSET;
        this.rateLimiterCountersMode = RateLimiterCountersMode.UNSET;
    }

    private NodeConfig(DescribeNodeResult result) {
        Preconditions.checkNotNull((Object)result, (Object)"DescriptionNodeResult must be not null");
        Preconditions.checkNotNull((Object)result.getConfig(), (Object)"DescriptionNodeResult config must be not null");
        this.selfCheckPeriod = Duration.ofMillis(result.getConfig().getSelfCheckPeriodMillis());
        this.sessionGracePeriod = Duration.ofMillis(result.getConfig().getSessionGracePeriodMillis());
        this.readConsistencyMode = NodeConfig.fromProto(result.getConfig().getReadConsistencyMode());
        this.attachConsistencyMode = NodeConfig.fromProto(result.getConfig().getAttachConsistencyMode());
        this.rateLimiterCountersMode = NodeConfig.fromProto(result.getConfig().getRateLimiterCountersMode());
    }

    private NodeConfig(Duration selfCheck, Duration sessionGrace, ConsistencyMode read, ConsistencyMode attach, RateLimiterCountersMode rateLimiter) {
        Preconditions.checkArgument((!selfCheck.isNegative() && !selfCheck.isZero() ? 1 : 0) != 0, (Object)"SelfCheckPeriod must be strictly greater than zero");
        Preconditions.checkArgument((!sessionGrace.isNegative() && !sessionGrace.isZero() ? 1 : 0) != 0, (Object)"SessionGracePeriod must be strictly greater than zero");
        Preconditions.checkArgument((sessionGrace.compareTo(selfCheck) > 0 ? 1 : 0) != 0, (Object)"SessionGracePeriod must be strictly more than SelfCheckPeriod");
        this.selfCheckPeriod = selfCheck;
        this.sessionGracePeriod = sessionGrace;
        this.readConsistencyMode = read;
        this.attachConsistencyMode = attach;
        this.rateLimiterCountersMode = rateLimiter;
    }

    public Duration getSelfCheckPeriod() {
        return this.selfCheckPeriod;
    }

    public Duration getSessionGracePeriod() {
        return this.sessionGracePeriod;
    }

    public ConsistencyMode getReadConsistencyMode() {
        return this.readConsistencyMode;
    }

    public ConsistencyMode getAttachConsistencyMode() {
        return this.attachConsistencyMode;
    }

    public RateLimiterCountersMode getRateLimiterCountersMode() {
        return this.rateLimiterCountersMode;
    }

    public NodeConfig withDurationsConfig(Duration selfCheck, Duration sessionGrace) {
        return new NodeConfig(selfCheck, sessionGrace, this.readConsistencyMode, this.attachConsistencyMode, this.rateLimiterCountersMode);
    }

    public NodeConfig withReadConsistencyMode(ConsistencyMode mode) {
        return new NodeConfig(this.selfCheckPeriod, this.sessionGracePeriod, mode, this.attachConsistencyMode, this.rateLimiterCountersMode);
    }

    public NodeConfig withAttachConsistencyMode(ConsistencyMode mode) {
        return new NodeConfig(this.selfCheckPeriod, this.sessionGracePeriod, this.readConsistencyMode, mode, this.rateLimiterCountersMode);
    }

    public NodeConfig withRateLimiterCountersMode(RateLimiterCountersMode mode) {
        return new NodeConfig(this.selfCheckPeriod, this.sessionGracePeriod, this.readConsistencyMode, this.attachConsistencyMode, mode);
    }

    public Config toProto() {
        return Config.newBuilder().setSelfCheckPeriodMillis((int)this.selfCheckPeriod.toMillis()).setSessionGracePeriodMillis((int)this.sessionGracePeriod.toMillis()).setReadConsistencyMode(NodeConfig.toProto(this.readConsistencyMode)).setAttachConsistencyMode(NodeConfig.toProto(this.attachConsistencyMode)).setRateLimiterCountersMode(NodeConfig.toProto(this.rateLimiterCountersMode)).build();
    }

    public static NodeConfig create() {
        return new NodeConfig();
    }

    public static NodeConfig fromProto(DescribeNodeResult result) {
        return new NodeConfig(result);
    }

    private static tech.ydb.proto.coordination.ConsistencyMode toProto(ConsistencyMode mode) {
        switch (mode) {
            case STRICT: {
                return tech.ydb.proto.coordination.ConsistencyMode.CONSISTENCY_MODE_STRICT;
            }
            case RELAXED: {
                return tech.ydb.proto.coordination.ConsistencyMode.CONSISTENCY_MODE_RELAXED;
            }
        }
        return tech.ydb.proto.coordination.ConsistencyMode.CONSISTENCY_MODE_UNSET;
    }

    private static tech.ydb.proto.coordination.RateLimiterCountersMode toProto(RateLimiterCountersMode mode) {
        switch (mode) {
            case DETAILED: {
                return tech.ydb.proto.coordination.RateLimiterCountersMode.RATE_LIMITER_COUNTERS_MODE_DETAILED;
            }
            case AGGREGATED: {
                return tech.ydb.proto.coordination.RateLimiterCountersMode.RATE_LIMITER_COUNTERS_MODE_AGGREGATED;
            }
        }
        return tech.ydb.proto.coordination.RateLimiterCountersMode.RATE_LIMITER_COUNTERS_MODE_UNSET;
    }

    private static ConsistencyMode fromProto(tech.ydb.proto.coordination.ConsistencyMode mode) {
        switch (mode) {
            case CONSISTENCY_MODE_RELAXED: {
                return ConsistencyMode.RELAXED;
            }
            case CONSISTENCY_MODE_STRICT: {
                return ConsistencyMode.STRICT;
            }
        }
        return ConsistencyMode.UNSET;
    }

    private static RateLimiterCountersMode fromProto(tech.ydb.proto.coordination.RateLimiterCountersMode mode) {
        switch (mode) {
            case RATE_LIMITER_COUNTERS_MODE_AGGREGATED: {
                return RateLimiterCountersMode.AGGREGATED;
            }
            case RATE_LIMITER_COUNTERS_MODE_DETAILED: {
                return RateLimiterCountersMode.DETAILED;
            }
        }
        return RateLimiterCountersMode.UNSET;
    }

    public static enum RateLimiterCountersMode {
        UNSET,
        AGGREGATED,
        DETAILED;

    }

    public static enum ConsistencyMode {
        UNSET,
        STRICT,
        RELAXED;

    }
}

