/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.scenario.configuration;

import com.google.protobuf.ByteString;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.coordination.CoordinationClient;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.scenario.WorkingScenario;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.proto.coordination.SessionRequest;

public class ConfigurationPublisher
extends WorkingScenario {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationPublisher.class);
    public static final int SEMAPHORE_LIMIT = 1;
    private final ConcurrentHashMap<Long, CompletableFuture<Status>> reqIdToStatus = new ConcurrentHashMap();

    private ConfigurationPublisher(CoordinationClient client, WorkingScenario.Settings settings) {
        super(client, settings, 1L);
    }

    public static Builder newBuilder(CoordinationClient client) {
        return new Builder(client);
    }

    public CompletableFuture<Status> publishData(byte[] bytes) {
        long reqId = ThreadLocalRandom.current().nextLong();
        CompletableFuture<Status> resultFuture = new CompletableFuture<Status>();
        this.reqIdToStatus.put(reqId, resultFuture);
        ((CoordinationSession)this.currentCoordinationSession.get()).sendUpdateSemaphore(SessionRequest.UpdateSemaphore.newBuilder().setReqId(reqId).setName(this.settings.getSemaphoreName()).setData(ByteString.copyFrom((byte[])bytes)).build());
        return resultFuture;
    }

    @Override
    public void stop() {
        super.stop();
        for (CompletableFuture<Status> futures : this.reqIdToStatus.values()) {
            futures.complete(Status.of((StatusCode)StatusCode.CANCELLED));
        }
        this.reqIdToStatus.clear();
    }

    public static class Builder
    extends WorkingScenario.Builder<ConfigurationPublisher> {
        public Builder(CoordinationClient client) {
            super(client);
        }

        @Override
        protected ConfigurationPublisher buildScenario(WorkingScenario.Settings settings) {
            final ConfigurationPublisher publisher = new ConfigurationPublisher(this.client, settings);
            publisher.start(new CoordinationSession.Observer(){

                @Override
                public void onUpdateSemaphoreResult(long reqId, Status status) {
                    CompletableFuture statusCompletableFuture = (CompletableFuture)publisher.reqIdToStatus.remove(reqId);
                    if (statusCompletableFuture != null) {
                        statusCompletableFuture.complete(status);
                    }
                }

                @Override
                public void onSessionStarted() {
                    logger.info("Starting coordination publisher session, sessionId: {}", (Object)((CoordinationSession)publisher.currentCoordinationSession.get()).getSessionId());
                }

                @Override
                public void onFailure(Status status) {
                    logger.error("Fail from publisher session: {}", (Object)status);
                }
            });
            return publisher;
        }
    }
}

