/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.core.Issue;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.proto.StatusCodesProtos;
import tech.ydb.proto.YdbIssueMessage;
import tech.ydb.proto.coordination.SessionRequest;
import tech.ydb.proto.coordination.SessionResponse;

public class CoordinationSessionImpl
implements CoordinationSession {
    private static final Logger logger = LoggerFactory.getLogger(CoordinationSessionImpl.class);
    private final GrpcReadWriteStream<SessionResponse, SessionRequest> coordinationStream;
    private final AtomicBoolean isWorking = new AtomicBoolean(true);
    private final CompletableFuture<SessionResponse> stoppedFuture = new CompletableFuture();
    private final AtomicLong sessionId = new AtomicLong();

    public CoordinationSessionImpl(GrpcReadWriteStream<SessionResponse, SessionRequest> coordinationStream) {
        this.coordinationStream = coordinationStream;
    }

    @Override
    public long getSessionId() {
        return this.sessionId.get();
    }

    @Override
    public CompletableFuture<Status> start(CoordinationSession.Observer observer) {
        return this.coordinationStream.start(message -> {
            if (logger.isTraceEnabled()) {
                logger.trace("Message received:\n{}", message);
            }
            if (message.hasSessionStopped()) {
                this.stoppedFuture.complete((SessionResponse)message);
                return;
            }
            if (this.isWorking.get()) {
                switch (message.getResponseCase()) {
                    case SESSION_STARTED: {
                        this.sessionId.set(message.getSessionStarted().getSessionId());
                        observer.onSessionStarted();
                        break;
                    }
                    case PING: {
                        this.coordinationStream.sendNext((Object)SessionRequest.newBuilder().setPong(SessionRequest.PingPong.newBuilder().setOpaque(message.getPing().getOpaque()).build()).build());
                        break;
                    }
                    case ACQUIRE_SEMAPHORE_RESULT: {
                        observer.onAcquireSemaphoreResult(message.getAcquireSemaphoreResult().getAcquired(), CoordinationSessionImpl.getStatus(message.getAcquireSemaphoreResult().getStatus(), message.getAcquireSemaphoreResult().getIssuesList()));
                        break;
                    }
                    case ACQUIRE_SEMAPHORE_PENDING: {
                        observer.onAcquireSemaphorePending();
                        break;
                    }
                    case FAILURE: {
                        observer.onFailure(CoordinationSessionImpl.getStatus(message.getFailure().getStatus(), message.getFailure().getIssuesList()));
                        break;
                    }
                    case DESCRIBE_SEMAPHORE_RESULT: {
                        observer.onDescribeSemaphoreResult(message.getDescribeSemaphoreResult().getSemaphoreDescription(), CoordinationSessionImpl.getStatus(message.getDescribeSemaphoreResult().getStatus(), message.getDescribeSemaphoreResult().getIssuesList()));
                        break;
                    }
                    case DESCRIBE_SEMAPHORE_CHANGED: {
                        observer.onDescribeSemaphoreChanged(message.getDescribeSemaphoreChanged().getDataChanged(), message.getDescribeSemaphoreChanged().getOwnersChanged());
                        break;
                    }
                    case DELETE_SEMAPHORE_RESULT: {
                        observer.onDeleteSemaphoreResult(CoordinationSessionImpl.getStatus(message.getDeleteSemaphoreResult().getStatus(), message.getDeleteSemaphoreResult().getIssuesList()));
                        break;
                    }
                    case CREATE_SEMAPHORE_RESULT: {
                        observer.onCreateSemaphoreResult(CoordinationSessionImpl.getStatus(message.getCreateSemaphoreResult().getStatus(), message.getCreateSemaphoreResult().getIssuesList()));
                        break;
                    }
                    case RELEASE_SEMAPHORE_RESULT: {
                        observer.onReleaseSemaphoreResult(message.getReleaseSemaphoreResult().getReleased(), CoordinationSessionImpl.getStatus(message.getReleaseSemaphoreResult().getStatus(), message.getReleaseSemaphoreResult().getIssuesList()));
                        break;
                    }
                    case UPDATE_SEMAPHORE_RESULT: {
                        observer.onUpdateSemaphoreResult(message.getUpdateSemaphoreResult().getReqId(), CoordinationSessionImpl.getStatus(message.getUpdateSemaphoreResult().getStatus(), message.getUpdateSemaphoreResult().getIssuesList()));
                        break;
                    }
                    case PONG: {
                        observer.onPong(message.getPong().getOpaque());
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void sendStartSession(SessionRequest.SessionStart sessionStart) {
        this.send(SessionRequest.newBuilder().setSessionStart(sessionStart).build());
    }

    @Override
    public void sendPingPong(SessionRequest.PingPong pingPong) {
        this.send(SessionRequest.newBuilder().setPing(pingPong).build());
    }

    @Override
    public void sendAcquireSemaphore(SessionRequest.AcquireSemaphore acquireSemaphore) {
        this.send(SessionRequest.newBuilder().setAcquireSemaphore(acquireSemaphore).build());
    }

    @Override
    public void sendReleaseSemaphore(SessionRequest.ReleaseSemaphore releaseSemaphore) {
        this.send(SessionRequest.newBuilder().setReleaseSemaphore(releaseSemaphore).build());
    }

    @Override
    public void sendDescribeSemaphore(SessionRequest.DescribeSemaphore describeSemaphore) {
        this.send(SessionRequest.newBuilder().setDescribeSemaphore(describeSemaphore).build());
    }

    @Override
    public void sendCreateSemaphore(SessionRequest.CreateSemaphore createSemaphore) {
        this.send(SessionRequest.newBuilder().setCreateSemaphore(createSemaphore).build());
    }

    @Override
    public void sendUpdateSemaphore(SessionRequest.UpdateSemaphore updateSemaphore) {
        this.send(SessionRequest.newBuilder().setUpdateSemaphore(updateSemaphore).build());
    }

    @Override
    public void sendDeleteSemaphore(SessionRequest.DeleteSemaphore deleteSemaphore) {
        this.send(SessionRequest.newBuilder().setDeleteSemaphore(deleteSemaphore).build());
    }

    @Override
    public void stop() {
        if (this.isWorking.compareAndSet(true, false)) {
            this.coordinationStream.sendNext((Object)SessionRequest.newBuilder().setSessionStop(SessionRequest.SessionStop.newBuilder().build()).build());
            try {
                this.stoppedFuture.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error("Failed stopping awaiting", (Throwable)e);
            }
            this.coordinationStream.close();
        }
    }

    private void send(SessionRequest sessionRequest) {
        if (logger.isTraceEnabled()) {
            logger.trace("Send message: {}", (Object)sessionRequest);
        }
        try {
            this.coordinationStream.sendNext((Object)sessionRequest);
        }
        catch (IllegalStateException e) {
            logger.error("Error sending message {}", (Object)sessionRequest, (Object)e);
        }
    }

    private static Status getStatus(StatusCodesProtos.StatusIds.StatusCode statusCode, List<YdbIssueMessage.IssueMessage> issueMessages) {
        return Status.of((StatusCode)StatusCode.fromProto((StatusCodesProtos.StatusIds.StatusCode)statusCode)).withIssues(Issue.fromPb(issueMessages));
    }
}

