/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.settings;

import com.google.common.base.Preconditions;
import tech.ydb.core.settings.OperationSettings;

public class CoordinationNodeSettings
extends OperationSettings {
    private final int selfCheckPeriodMillis;
    private final int sessionGracePeriodMillis;
    private final ConsistencyMode readConsistencyMode;
    private final ConsistencyMode attachConsistencyMode;
    private final RateLimiterCountersMode rateLimiterCountersMode;

    private CoordinationNodeSettings(Builder builder) {
        super((OperationSettings.OperationBuilder)builder);
        Preconditions.checkArgument((builder.selfCheckPeriodMillis < builder.sessionGracePeriodMillis ? 1 : 0) != 0, (Object)"SessionGracePeriod must be strictly more than SelfCheckPeriod");
        this.selfCheckPeriodMillis = builder.selfCheckPeriodMillis;
        this.sessionGracePeriodMillis = builder.sessionGracePeriodMillis;
        this.readConsistencyMode = builder.readConsistencyMode;
        this.attachConsistencyMode = builder.attachConsistencyMode;
        this.rateLimiterCountersMode = builder.rateLimiterCountersMode;
    }

    public int getSelfCheckPeriodMillis() {
        return this.selfCheckPeriodMillis;
    }

    public int getSessionGracePeriodMillis() {
        return this.sessionGracePeriodMillis;
    }

    public ConsistencyMode getReadConsistencyMode() {
        return this.readConsistencyMode;
    }

    public ConsistencyMode getAttachConsistencyMode() {
        return this.attachConsistencyMode;
    }

    public RateLimiterCountersMode getRateLimiterCountersMode() {
        return this.rateLimiterCountersMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends OperationSettings.OperationBuilder<Builder> {
        private int selfCheckPeriodMillis = 1000;
        private int sessionGracePeriodMillis = 10000;
        private ConsistencyMode readConsistencyMode = ConsistencyMode.CONSISTENCY_MODE_RELAXED;
        private ConsistencyMode attachConsistencyMode = ConsistencyMode.CONSISTENCY_MODE_STRICT;
        private RateLimiterCountersMode rateLimiterCountersMode = null;

        public Builder setSelfCheckPeriodMillis(int selfCheckPeriodMillis) {
            Preconditions.checkArgument((selfCheckPeriodMillis > 0 ? 1 : 0) != 0, (Object)"SelfCheckPeriod must be strictly greater than zero");
            this.selfCheckPeriodMillis = selfCheckPeriodMillis;
            return this;
        }

        public Builder setSessionGracePeriodMillis(int sessionGracePeriodMillis) {
            Preconditions.checkArgument((sessionGracePeriodMillis > 0 ? 1 : 0) != 0, (Object)"SessionGracePeriod must be strictly greater than zero");
            this.sessionGracePeriodMillis = sessionGracePeriodMillis;
            return this;
        }

        public Builder setReadConsistencyMode(ConsistencyMode readConsistencyMode) {
            this.readConsistencyMode = readConsistencyMode;
            return this;
        }

        public Builder setAttachConsistencyMode(ConsistencyMode attachConsistencyMode) {
            this.attachConsistencyMode = attachConsistencyMode;
            return this;
        }

        public Builder setRateLimiterCountersMode(RateLimiterCountersMode rateLimiterCountersMode) {
            this.rateLimiterCountersMode = rateLimiterCountersMode;
            return this;
        }

        public CoordinationNodeSettings build() {
            return new CoordinationNodeSettings(this);
        }
    }

    public static enum RateLimiterCountersMode {
        RATE_LIMITER_COUNTERS_MODE_AGGREGATED,
        RATE_LIMITER_COUNTERS_MODE_DETAILED;

    }

    public static enum ConsistencyMode {
        CONSISTENCY_MODE_STRICT,
        CONSISTENCY_MODE_RELAXED;

    }
}

