/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.scenario.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.coordination.CoordinationClient;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.scenario.WorkingScenario;
import tech.ydb.core.Status;
import tech.ydb.proto.coordination.SemaphoreDescription;
import tech.ydb.proto.coordination.SessionRequest;

public class ConfigurationSubscriber
extends WorkingScenario {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationSubscriber.class);

    private ConfigurationSubscriber(CoordinationClient client, WorkingScenario.Settings settings) {
        super(client, settings, 1L);
    }

    public static Builder newBuilder(CoordinationClient client, Observer observer) {
        return new Builder(client, observer);
    }

    private void describeSemaphore() {
        ((CoordinationSession)this.currentCoordinationSession.get()).sendDescribeSemaphore(SessionRequest.DescribeSemaphore.newBuilder().setName(this.settings.getSemaphoreName()).setWatchData(true).build());
    }

    public static class Builder
    extends WorkingScenario.Builder<ConfigurationSubscriber> {
        private final Observer observer;

        public Builder(CoordinationClient client, Observer observer) {
            super(client);
            this.observer = observer;
        }

        @Override
        protected ConfigurationSubscriber buildScenario(final WorkingScenario.Settings settings) {
            final ConfigurationSubscriber subscriber = new ConfigurationSubscriber(this.client, settings);
            subscriber.start(new CoordinationSession.Observer(){

                @Override
                public void onSessionStarted() {
                    logger.info("Starting subscriber coordination session, sessionId: {}", (Object)((CoordinationSession)subscriber.currentCoordinationSession.get()).getSessionId());
                }

                @Override
                public void onCreateSemaphoreResult(Status status) {
                    logger.info("Creating semaphore {}, with status: {}", (Object)settings.getSemaphoreName(), (Object)status);
                    subscriber.describeSemaphore();
                }

                @Override
                public void onDescribeSemaphoreResult(SemaphoreDescription semaphoreDescription, Status status) {
                    if (status.isSuccess()) {
                        observer.onNext(semaphoreDescription.getData().toByteArray());
                    } else {
                        logger.error("Error describer result from configuration subscriber session, status: {}", (Object)status);
                    }
                }

                @Override
                public void onDescribeSemaphoreChanged(boolean dataChanged, boolean ownersChanged) {
                    if (dataChanged) {
                        subscriber.describeSemaphore();
                    }
                }

                @Override
                public void onFailure(Status status) {
                    logger.error("Failed from subscriber session: {}", (Object)status);
                }
            });
            return subscriber;
        }
    }

    public static interface Observer {
        public void onNext(byte[] var1);
    }
}

