/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.scenario;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.coordination.CoordinationClient;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.settings.CoordinationNodeSettings;
import tech.ydb.core.Status;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.proto.coordination.SessionRequest;

public abstract class WorkingScenario {
    private static final Logger logger = LoggerFactory.getLogger(WorkingScenario.class);
    protected final AtomicReference<CoordinationSession> currentCoordinationSession;
    protected final AtomicBoolean isWorking = new AtomicBoolean(true);
    protected final Settings settings;
    private final CoordinationClient client;
    private final long semaphoreLimit;

    public WorkingScenario(CoordinationClient client, Settings settings, long semaphoreLimit) {
        this.client = client;
        this.settings = settings;
        this.semaphoreLimit = semaphoreLimit;
        this.currentCoordinationSession = new AtomicReference<CoordinationSession>(client.createSession());
    }

    protected void start(CoordinationSession.Observer observer) {
        this.tryStart(null, observer);
    }

    protected void tryStart(Status status, CoordinationSession.Observer observer) {
        if (status != null) {
            logger.info("Stopped session with status: {}", (Object)status);
        }
        if (this.isWorking.get()) {
            logger.info("Starting session...");
            CoordinationSession coordinationSession = this.client.createSession();
            coordinationSession.start(observer).whenComplete((completableStatus, throwable) -> {
                if (throwable != null) {
                    logger.error("Failed coordination session", throwable);
                }
                try {
                    this.tryStart((Status)completableStatus, observer);
                }
                catch (RuntimeException e) {
                    logger.error("Failed trying start session", (Throwable)e);
                }
            });
            this.currentCoordinationSession.set(coordinationSession);
            byte[] protectionKey = new byte[16];
            ThreadLocalRandom.current().nextBytes(protectionKey);
            coordinationSession.sendStartSession(SessionRequest.SessionStart.newBuilder().setSessionId(0L).setPath(this.settings.getCoordinationNodePath()).setDescription(this.settings.getDescription()).setTimeoutMillis(0L).setProtectionKey(ByteString.copyFrom((byte[])protectionKey)).build());
            coordinationSession.sendCreateSemaphore(SessionRequest.CreateSemaphore.newBuilder().setName(this.settings.getSemaphoreName()).setLimit(this.semaphoreLimit).build());
        }
    }

    public void stop() {
        block1: {
            CoordinationSession coordinationSession;
            if (!this.isWorking.compareAndSet(true, false)) break block1;
            logger.info("Stopping session...");
            do {
                if ((coordinationSession = this.currentCoordinationSession.get()) == null) continue;
                coordinationSession.stop();
            } while (!this.currentCoordinationSession.compareAndSet(coordinationSession, coordinationSession));
        }
    }

    public static abstract class Builder<T extends WorkingScenario> {
        protected final CoordinationClient client;
        private String coordinationNodeName = "coordination-node-default";
        private String semaphoreName = "semaphore-default";
        private String description = "";

        public Builder(CoordinationClient client) {
            this.client = client;
        }

        public Builder<T> setCoordinationNodeName(@Nonnull String coordinationNodeName) {
            this.coordinationNodeName = (String)Preconditions.checkNotNull((Object)coordinationNodeName, (Object)"Coordination node name shouldn\u2019t be null!");
            return this;
        }

        public Builder<T> setSemaphoreName(@Nonnull String semaphoreName) {
            this.semaphoreName = (String)Preconditions.checkNotNull((Object)semaphoreName, (Object)"Session semaphore name shouldn't be null!");
            return this;
        }

        public Builder<T> setDescription(@Nonnull String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"Descriptions shouldn\u2019t be null!");
            return this;
        }

        protected abstract T buildScenario(Settings var1);

        public CompletableFuture<T> start() {
            if (!this.coordinationNodeName.startsWith(this.client.getDatabase())) {
                this.setCoordinationNodeName(this.client.getDatabase() + "/" + this.coordinationNodeName);
            }
            return this.client.createNode(this.coordinationNodeName, CoordinationNodeSettings.newBuilder().build()).thenApply(status -> {
                if (status.isSuccess()) {
                    return this.buildScenario(new Settings(this));
                }
                throw new UnexpectedResultException("Fail creating scenario", status);
            });
        }
    }

    protected static class Settings {
        public static final int START_SESSION_ID = 0;
        public static final int SESSION_KEEP_ALIVE_TIMEOUT_MS = 0;
        private final String coordinationNodePath;
        private final String semaphoreName;
        private final String description;

        Settings(Builder<?> builder) {
            this.coordinationNodePath = ((Builder)builder).coordinationNodeName;
            this.semaphoreName = ((Builder)builder).semaphoreName;
            this.description = ((Builder)builder).description;
        }

        public String getCoordinationNodePath() {
            return this.coordinationNodePath;
        }

        public String getSemaphoreName() {
            return this.semaphoreName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

