/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.scenario.service_discovery;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.coordination.CoordinationClient;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.scenario.WorkingScenario;
import tech.ydb.core.Status;
import tech.ydb.proto.coordination.SemaphoreDescription;
import tech.ydb.proto.coordination.SessionRequest;

public class ServiceDiscoverySubscriber
extends WorkingScenario {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoverySubscriber.class);

    private ServiceDiscoverySubscriber(CoordinationClient client, WorkingScenario.Settings settings) {
        super(client, settings, Long.MAX_VALUE);
    }

    public static Builder newBuilder(CoordinationClient client, Observer observer) {
        return new Builder(client, observer);
    }

    private void describeSemaphore() {
        ((CoordinationSession)this.currentCoordinationSession.get()).sendDescribeSemaphore(SessionRequest.DescribeSemaphore.newBuilder().setName(this.settings.getSemaphoreName()).setIncludeOwners(true).setWatchOwners(true).build());
    }

    public static class Builder
    extends WorkingScenario.Builder<ServiceDiscoverySubscriber> {
        private final Observer observer;

        public Builder(CoordinationClient client, Observer observer) {
            super(client);
            this.observer = observer;
        }

        @Override
        protected ServiceDiscoverySubscriber buildScenario(final WorkingScenario.Settings settings) {
            final ServiceDiscoverySubscriber subscriber = new ServiceDiscoverySubscriber(this.client, settings);
            subscriber.start(new CoordinationSession.Observer(){

                @Override
                public void onSessionStarted() {
                    logger.info("Starting service discovery subscriber session, sessionId: {}", (Object)((CoordinationSession)subscriber.currentCoordinationSession.get()).getSessionId());
                }

                @Override
                public void onCreateSemaphoreResult(Status status) {
                    logger.info("Creating semaphore {}, with status: {}", (Object)settings.getSemaphoreName(), (Object)status);
                    subscriber.describeSemaphore();
                }

                @Override
                public void onDescribeSemaphoreResult(SemaphoreDescription semaphoreDescription, Status status) {
                    if (status.isSuccess()) {
                        observer.onNext(semaphoreDescription.getOwnersList().stream().map(semaphoreSession -> semaphoreSession.getData().toString(StandardCharsets.UTF_8)).collect(Collectors.toList()));
                    } else {
                        logger.error("Error describer result from service discovery subscriber session, status: {}", (Object)status);
                    }
                }

                @Override
                public void onDescribeSemaphoreChanged(boolean dataChanged, boolean ownersChanged) {
                    if (ownersChanged) {
                        subscriber.describeSemaphore();
                    }
                }
            });
            return subscriber;
        }
    }

    public static interface Observer {
        public void onNext(List<String> var1);
    }
}

