/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination;

import java.util.concurrent.CompletableFuture;
import tech.ydb.core.Status;
import tech.ydb.proto.coordination.SemaphoreDescription;
import tech.ydb.proto.coordination.SessionRequest;

public interface CoordinationSession {
    public long getSessionId();

    public CompletableFuture<Status> start(Observer var1);

    public void sendStartSession(SessionRequest.SessionStart var1);

    public void sendPingPong(SessionRequest.PingPong var1);

    public void sendAcquireSemaphore(SessionRequest.AcquireSemaphore var1);

    public void sendReleaseSemaphore(SessionRequest.ReleaseSemaphore var1);

    public void sendDescribeSemaphore(SessionRequest.DescribeSemaphore var1);

    public void sendCreateSemaphore(SessionRequest.CreateSemaphore var1);

    public void sendUpdateSemaphore(SessionRequest.UpdateSemaphore var1);

    public void sendDeleteSemaphore(SessionRequest.DeleteSemaphore var1);

    public void stop();

    public static interface Observer {
        default public void onAcquireSemaphoreResult(boolean acquired, Status status) {
        }

        default public void onAcquireSemaphorePending() {
        }

        default public void onDescribeSemaphoreResult(SemaphoreDescription semaphoreDescription, Status status) {
        }

        default public void onDescribeSemaphoreChanged(boolean dataChanged, boolean ownersChanged) {
        }

        default public void onDeleteSemaphoreResult(Status status) {
        }

        default public void onCreateSemaphoreResult(Status status) {
        }

        default public void onFailure(Status status) {
        }

        default public void onReleaseSemaphoreResult(boolean released, Status status) {
        }

        default public void onUpdateSemaphoreResult(long reqId, Status status) {
        }

        default public void onSessionStarted() {
        }

        default public void onPong(long pingValue) {
        }
    }
}

