/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.impl;

import java.util.concurrent.CompletableFuture;
import tech.ydb.coordination.CoordinationClient;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.impl.CoordinationSessionImpl;
import tech.ydb.coordination.rpc.CoordinationRpc;
import tech.ydb.coordination.settings.CoordinationNodeSettings;
import tech.ydb.coordination.settings.DescribeCoordinationNodeSettings;
import tech.ydb.coordination.settings.DropCoordinationNodeSettings;
import tech.ydb.core.Operations;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.core.settings.OperationSettings;
import tech.ydb.proto.coordination.AlterNodeRequest;
import tech.ydb.proto.coordination.Config;
import tech.ydb.proto.coordination.ConsistencyMode;
import tech.ydb.proto.coordination.CreateNodeRequest;
import tech.ydb.proto.coordination.DescribeNodeRequest;
import tech.ydb.proto.coordination.DropNodeRequest;
import tech.ydb.proto.coordination.RateLimiterCountersMode;

public class CoordinationClientImpl
implements CoordinationClient {
    private final CoordinationRpc coordinationRpc;

    public CoordinationClientImpl(CoordinationRpc grpcCoordinationRpc) {
        this.coordinationRpc = grpcCoordinationRpc;
    }

    @Override
    public CoordinationSession createSession() {
        return new CoordinationSessionImpl(this.coordinationRpc.session());
    }

    @Override
    public CompletableFuture<Status> createNode(String path, CoordinationNodeSettings coordinationNodeSettings) {
        return this.coordinationRpc.createNode(CreateNodeRequest.newBuilder().setPath(path).setOperationParams(Operations.createParams((OperationSettings)coordinationNodeSettings)).setConfig(CoordinationClientImpl.createConfig(coordinationNodeSettings)).build(), this.createGrpcRequestSettings((BaseRequestSettings)coordinationNodeSettings));
    }

    @Override
    public CompletableFuture<Status> alterNode(String path, CoordinationNodeSettings coordinationNodeSettings) {
        return this.coordinationRpc.alterNode(AlterNodeRequest.newBuilder().setPath(path).setOperationParams(Operations.createParams((OperationSettings)coordinationNodeSettings)).setConfig(CoordinationClientImpl.createConfig(coordinationNodeSettings)).build(), this.createGrpcRequestSettings((BaseRequestSettings)coordinationNodeSettings));
    }

    @Override
    public CompletableFuture<Status> dropNode(String path, DropCoordinationNodeSettings dropCoordinationNodeSettings) {
        return this.coordinationRpc.dropNode(DropNodeRequest.newBuilder().setPath(path).setOperationParams(Operations.createParams((OperationSettings)dropCoordinationNodeSettings)).build(), this.createGrpcRequestSettings((BaseRequestSettings)dropCoordinationNodeSettings));
    }

    @Override
    public CompletableFuture<Status> describeNode(String path, DescribeCoordinationNodeSettings describeCoordinationNodeSettings) {
        return this.coordinationRpc.describeNode(DescribeNodeRequest.newBuilder().setPath(path).setOperationParams(Operations.createParams((OperationSettings)describeCoordinationNodeSettings)).build(), this.createGrpcRequestSettings((BaseRequestSettings)describeCoordinationNodeSettings));
    }

    @Override
    public String getDatabase() {
        return this.coordinationRpc.getDatabase();
    }

    private static ConsistencyMode toProto(CoordinationNodeSettings.ConsistencyMode consistencyMode) {
        switch (consistencyMode) {
            case CONSISTENCY_MODE_STRICT: {
                return ConsistencyMode.CONSISTENCY_MODE_STRICT;
            }
            case CONSISTENCY_MODE_RELAXED: {
                return ConsistencyMode.CONSISTENCY_MODE_RELAXED;
            }
        }
        throw new RuntimeException("Unknown consistency mode: " + (Object)((Object)consistencyMode));
    }

    private static RateLimiterCountersMode toProto(CoordinationNodeSettings.RateLimiterCountersMode rateLimiterCountersMode) {
        switch (rateLimiterCountersMode) {
            case RATE_LIMITER_COUNTERS_MODE_DETAILED: {
                return RateLimiterCountersMode.RATE_LIMITER_COUNTERS_MODE_DETAILED;
            }
            case RATE_LIMITER_COUNTERS_MODE_AGGREGATED: {
                return RateLimiterCountersMode.RATE_LIMITER_COUNTERS_MODE_AGGREGATED;
            }
        }
        throw new RuntimeException("Unknown rate limiter counters mode: " + (Object)((Object)rateLimiterCountersMode));
    }

    private static Config createConfig(CoordinationNodeSettings coordinationNodeSettings) {
        Config.Builder configBuilder = Config.newBuilder().setSelfCheckPeriodMillis(coordinationNodeSettings.getSelfCheckPeriodMillis()).setSessionGracePeriodMillis(coordinationNodeSettings.getSessionGracePeriodMillis()).setReadConsistencyMode(CoordinationClientImpl.toProto(coordinationNodeSettings.getReadConsistencyMode())).setAttachConsistencyMode(CoordinationClientImpl.toProto(coordinationNodeSettings.getAttachConsistencyMode()));
        if (coordinationNodeSettings.getRateLimiterCountersMode() != null) {
            configBuilder.setRateLimiterCountersMode(CoordinationClientImpl.toProto(coordinationNodeSettings.getRateLimiterCountersMode()));
        }
        return configBuilder.build();
    }

    private GrpcRequestSettings createGrpcRequestSettings(BaseRequestSettings settings) {
        return GrpcRequestSettings.newBuilder().withDeadline(settings.getRequestTimeout()).build();
    }
}

