/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.common.retry;

import tech.ydb.common.retry.ExponentialBackoffRetry;

public class RetryUntilElapsed
extends ExponentialBackoffRetry {
    private final long maxElapsedMs;

    public RetryUntilElapsed(long maxElapsedMs, long backoffMs, int backoffCeiling) {
        super(backoffMs, backoffCeiling);
        this.maxElapsedMs = maxElapsedMs;
    }

    @Override
    public long nextRetryMs(int retryCount, long elapsedTimeMs) {
        if (this.maxElapsedMs <= elapsedTimeMs) {
            return -1L;
        }
        long backoff = this.backoffTimeMillis(retryCount);
        return elapsedTimeMs + backoff < this.maxElapsedMs ? backoff : this.maxElapsedMs - elapsedTimeMs;
    }

    public long getMaxElapsedMillis() {
        return this.maxElapsedMs;
    }

    public RetryUntilElapsed withMaxElapsedMs(long maxElapsedMs) {
        return new RetryUntilElapsed(maxElapsedMs, this.getBackoffMillis(), this.getBackoffCeiling());
    }

    public RetryUntilElapsed withBackoffMs(long ms) {
        return new RetryUntilElapsed(this.maxElapsedMs, ms, this.getBackoffCeiling());
    }

    public RetryUntilElapsed withBackoffCeiling(int ceiling) {
        return new RetryUntilElapsed(this.maxElapsedMs, this.getBackoffMillis(), ceiling);
    }
}

