/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.common.retry;

import tech.ydb.common.retry.ExponentialBackoffRetry;

public class RetryNTimes
extends ExponentialBackoffRetry {
    private final int maxRetries;

    public RetryNTimes(int maxRetries, long backoffMs, int backoffCeiling) {
        super(backoffMs, backoffCeiling);
        this.maxRetries = maxRetries;
    }

    @Override
    public long nextRetryMs(int retryCount, long elapsedTimeMs) {
        if (retryCount >= this.maxRetries) {
            return -1L;
        }
        return this.backoffTimeMillis(retryCount);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RetryNTimes withMaxRetries(int maxRetries) {
        return new RetryNTimes(maxRetries, this.getBackoffMillis(), this.getBackoffCeiling());
    }

    public RetryNTimes withBackoffMs(long ms) {
        return new RetryNTimes(this.maxRetries, ms, this.getBackoffCeiling());
    }

    public RetryNTimes withBackoffCeiling(int ceiling) {
        return new RetryNTimes(this.maxRetries, this.getBackoffMillis(), ceiling);
    }
}

