/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.docker;

import com.google.common.io.ByteStreams;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Grpc;
import io.grpc.HandlerRegistry;
import io.grpc.InsecureServerCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerCredentials;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.proto.discovery.v1.DiscoveryServiceGrpc;
import tech.ydb.test.integration.docker.DiscoveryServiceProxy;

public class GrpcProxyServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GrpcProxyServer.class);
    private final ManagedChannel target;
    private final Server server;
    private final EndpointRecord endpoint;

    public GrpcProxyServer(ManagedChannel target, int port) {
        this.target = target;
        this.server = Grpc.newServerBuilderForPort((int)port, (ServerCredentials)InsecureServerCredentials.create()).fallbackHandlerRegistry((HandlerRegistry)new ProxyRegistry()).build();
        try {
            this.server.start();
            logger.info("grpc proxy server started on port {}", (Object)this.server.getPort());
        }
        catch (IOException ex) {
            logger.error("cannot start proxy server", (Throwable)ex);
        }
        this.endpoint = new EndpointRecord(InetAddress.getLoopbackAddress().getHostName(), this.server.getPort());
    }

    public EndpointRecord endpoint() {
        return this.endpoint;
    }

    @Override
    public void close() {
        this.server.shutdown();
    }

    private static class ByteMarshaller
    implements MethodDescriptor.Marshaller<byte[]> {
        private ByteMarshaller() {
        }

        public byte[] parse(InputStream stream) {
            try {
                return ByteStreams.toByteArray((InputStream)stream);
            }
            catch (IOException ex) {
                throw new RuntimeException();
            }
        }

        public InputStream stream(byte[] value) {
            return new ByteArrayInputStream(value);
        }
    }

    private class ProxyRegistry
    extends HandlerRegistry {
        private final ByteMarshaller marshaller = new ByteMarshaller();
        private final ProxyHandler<byte[], byte[]> handler = new ProxyHandler();

        private ProxyRegistry() {
        }

        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, String authority) {
            if (DiscoveryServiceGrpc.getListEndpointsMethod().getFullMethodName().equals(methodName)) {
                logger.info("use custom proxy for method {}", (Object)methodName);
                return new DiscoveryServiceProxy(GrpcProxyServer.this.endpoint).toMethodDefinition();
            }
            MethodDescriptor descriptor = MethodDescriptor.newBuilder((MethodDescriptor.Marshaller)this.marshaller, (MethodDescriptor.Marshaller)this.marshaller).setFullMethodName(methodName).setType(MethodDescriptor.MethodType.UNKNOWN).build();
            return ServerMethodDefinition.create((MethodDescriptor)descriptor, this.handler);
        }
    }

    private class ProxyHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private ProxyHandler() {
        }

        public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
            ClientCall clientCall = GrpcProxyServer.this.target.newCall(serverCall.getMethodDescriptor(), CallOptions.DEFAULT);
            CallProxy<ReqT, RespT> proxy = new CallProxy<ReqT, RespT>(serverCall, clientCall);
            clientCall.start((ClientCall.Listener)proxy.clientCallListener, metadata);
            serverCall.request(1);
            clientCall.request(1);
            return proxy.serverCallListener;
        }
    }

    private static class CallProxy<ReqT, RespT> {
        final RequestProxy serverCallListener;
        final ResponseProxy clientCallListener;

        CallProxy(ServerCall<ReqT, RespT> serverCall, ClientCall<ReqT, RespT> clientCall) {
            this.serverCallListener = new RequestProxy(clientCall);
            this.clientCallListener = new ResponseProxy(serverCall);
        }

        private class ResponseProxy
        extends ClientCall.Listener<RespT> {
            private final ServerCall<?, RespT> serverCall;
            private boolean needToRequest;

            ResponseProxy(ServerCall<?, RespT> serverCall) {
                this.serverCall = serverCall;
            }

            public void onClose(Status status, Metadata trailers) {
                this.serverCall.close(status, trailers);
            }

            public void onHeaders(Metadata headers) {
                this.serverCall.sendHeaders(headers);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(RespT message) {
                this.serverCall.sendMessage(message);
                ResponseProxy responseProxy = this;
                synchronized (responseProxy) {
                    if (this.serverCall.isReady()) {
                        CallProxy.this.serverCallListener.clientCall.request(1);
                    } else {
                        this.needToRequest = true;
                    }
                }
            }

            public void onReady() {
                CallProxy.this.serverCallListener.onClientReady();
            }

            synchronized void onServerReady() {
                if (this.needToRequest) {
                    CallProxy.this.serverCallListener.clientCall.request(1);
                    this.needToRequest = false;
                }
            }
        }

        private class RequestProxy
        extends ServerCall.Listener<ReqT> {
            private final ClientCall<ReqT, ?> clientCall;
            private boolean needToRequest;

            RequestProxy(ClientCall<ReqT, ?> clientCall) {
                this.clientCall = clientCall;
            }

            public void onCancel() {
                this.clientCall.cancel("Server cancelled", null);
            }

            public void onHalfClose() {
                this.clientCall.halfClose();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(ReqT message) {
                this.clientCall.sendMessage(message);
                RequestProxy requestProxy = this;
                synchronized (requestProxy) {
                    if (this.clientCall.isReady()) {
                        CallProxy.this.clientCallListener.serverCall.request(1);
                    } else {
                        this.needToRequest = true;
                    }
                }
            }

            public void onReady() {
                CallProxy.this.clientCallListener.onServerReady();
            }

            synchronized void onClientReady() {
                if (this.needToRequest) {
                    CallProxy.this.clientCallListener.serverCall.request(1);
                    this.needToRequest = false;
                }
            }
        }
    }
}

