/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.docker;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.proto.OperationProtos;
import tech.ydb.proto.StatusCodesProtos;
import tech.ydb.proto.discovery.DiscoveryProtos;
import tech.ydb.proto.discovery.v1.DiscoveryServiceGrpc;

public class DiscoveryServiceProxy
implements ServerCallHandler<DiscoveryProtos.ListEndpointsRequest, DiscoveryProtos.ListEndpointsResponse> {
    private final EndpointRecord endpoint;

    public DiscoveryServiceProxy(EndpointRecord endpoint) {
        this.endpoint = endpoint;
    }

    public ServerMethodDefinition<?, ?> toMethodDefinition() {
        return ServerMethodDefinition.create((MethodDescriptor)DiscoveryServiceGrpc.getListEndpointsMethod(), (ServerCallHandler)this);
    }

    public ServerCall.Listener<DiscoveryProtos.ListEndpointsRequest> startCall(final ServerCall<DiscoveryProtos.ListEndpointsRequest, DiscoveryProtos.ListEndpointsResponse> serverCall, Metadata metadata) {
        serverCall.request(1);
        serverCall.sendHeaders(new Metadata());
        return new ServerCall.Listener<DiscoveryProtos.ListEndpointsRequest>(){

            public void onMessage(DiscoveryProtos.ListEndpointsRequest message) {
                serverCall.sendMessage((Object)DiscoveryServiceProxy.this.createDiscoveryResponse());
            }

            public void onHalfClose() {
                serverCall.close(Status.OK, new Metadata());
            }
        };
    }

    private DiscoveryProtos.ListEndpointsResponse createDiscoveryResponse() {
        DiscoveryProtos.ListEndpointsResult result = DiscoveryProtos.ListEndpointsResult.newBuilder().setSelfLocation("PROXY").addEndpoints(DiscoveryProtos.EndpointInfo.newBuilder().setAddress(this.endpoint.getHost()).setPort(this.endpoint.getPort()).build()).build();
        OperationProtos.Operation operation = OperationProtos.Operation.newBuilder().setReady(true).setStatus(StatusCodesProtos.StatusIds.StatusCode.SUCCESS).setId("grpc-proxy-discovery").setResult(Any.pack((Message)result)).build();
        return DiscoveryProtos.ListEndpointsResponse.newBuilder().setOperation(operation).build();
    }
}

