/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration;

import com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Supplier;
import org.testcontainers.shaded.com.google.common.base.Suppliers;

public class YdbEnvironment {
    private static final String YDB_DEFAULT_IMAGE = "cr.yandex/yc/yandex-docker-local-ydb:latest";
    private final Supplier<String> ydbEndpoint = this.createParam("YDB_ENDPOINT", null);
    private final Supplier<String> ydbDatabase = this.createParam("YDB_DATABASE", null);
    private final Supplier<String> ydbAuthToken = this.createParam("YDB_TOKEN", null);
    private final Supplier<String> ydbPemCert = this.createParam("YDB_PEM_CERT", null);
    private final Supplier<Boolean> ydbUseTls = this.createParam("YDB_USE_TLS", false);
    private final Supplier<String> dockerImage = this.createParam("YDB_DOCKER_IMAGE", "cr.yandex/yc/yandex-docker-local-ydb:latest");
    private final Supplier<String> dockerDatabase = this.createParam("YDB_DOCKER_DATABASE", "/local");
    private final Supplier<String> dockerPemPath = this.createParam("YDB_DOCKER_PEM_PATH", "/ydb_certs/ca.pem");
    private final Supplier<String> dockerFeatures = this.createParam("YDB_DOCKER_FEATURE_FLAGS", "");
    private final Supplier<Boolean> dockerReuse = this.createParam("YDB_DOCKER_REUSE", true);
    private final Supplier<Boolean> cleanUpTests = this.createParam("YDB_CLEAN_UP", true);
    private final Supplier<Boolean> disableIntegrationTests = this.createParam("YDB_DISABLE_INTEGRATION_TESTS", false);
    private final Supplier<Boolean> useDockerIsolation = this.createParam("YDB_DOCKER_ISOLATION", false);

    public String ydbEndpoint() {
        return (String)this.ydbEndpoint.get();
    }

    public String ydbDatabase() {
        return (String)this.ydbDatabase.get();
    }

    public String ydbAuthToken() {
        return (String)this.ydbAuthToken.get();
    }

    public String ydbPemCert() {
        return (String)this.ydbPemCert.get();
    }

    public boolean ydbUseTls() {
        return (Boolean)this.ydbUseTls.get();
    }

    public String dockerImage() {
        return (String)this.dockerImage.get();
    }

    public String dockerDatabase() {
        return (String)this.dockerDatabase.get();
    }

    public String dockerPemPath() {
        return (String)this.dockerPemPath.get();
    }

    public boolean dockerReuse() {
        return (Boolean)this.dockerReuse.get();
    }

    public String dockerFeatures() {
        return (String)this.dockerFeatures.get();
    }

    public boolean cleanUpTests() {
        return (Boolean)this.cleanUpTests.get();
    }

    public boolean disableIntegrationTests() {
        return (Boolean)this.disableIntegrationTests.get();
    }

    public boolean useDockerIsolation() {
        return (Boolean)this.useDockerIsolation.get();
    }

    private Supplier<String> createParam(String key, String defaultValue) {
        return Suppliers.memoize(() -> YdbEnvironment.readParam(key, defaultValue));
    }

    private Supplier<Boolean> createParam(String key, boolean defaultValue) {
        return Suppliers.memoize(() -> YdbEnvironment.readParam(key, defaultValue));
    }

    @VisibleForTesting
    static String readParam(String key, String defaultValue) {
        String env = System.getenv(key);
        if (env != null && !env.isEmpty()) {
            return env;
        }
        return System.getProperty(key, defaultValue);
    }

    @VisibleForTesting
    static Boolean readParam(String key, boolean defaultValue) {
        String env = System.getenv(key);
        if (env != null && !env.isEmpty()) {
            return Boolean.valueOf(env);
        }
        env = System.getProperty(key);
        if (env != null && !env.isEmpty()) {
            return Boolean.valueOf(env);
        }
        return defaultValue;
    }
}

