/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.docker;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.UUID;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.utility.ResourceReaper;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.test.integration.YdbEnvironment;
import tech.ydb.test.integration.utils.PortsGenerator;

public class YdbDockerContainer
extends GenericContainer<YdbDockerContainer> {
    public static final int DEFAULT_SECURE_PORT = 2135;
    public static final int DEFAULT_INSECURE_PORT = 2136;
    private final YdbEnvironment env;
    private final int grpcsPort;
    private final int grpcPort;

    public YdbDockerContainer(YdbEnvironment env, PortsGenerator portGenerator) {
        super(env.dockerImage());
        this.env = env;
        if (env.useDockerIsolation()) {
            this.grpcsPort = 2135;
            this.grpcPort = 2136;
        } else {
            this.grpcsPort = portGenerator.findAvailablePort();
            this.grpcPort = portGenerator.findAvailablePort();
        }
    }

    public void init() {
        this.addExposedPort(this.grpcPort);
        this.addExposedPort(this.grpcsPort);
        if (!this.env.useDockerIsolation()) {
            this.addFixedExposedPort(this.grpcsPort, this.grpcsPort);
            this.addFixedExposedPort(this.grpcPort, this.grpcPort);
            this.withEnv("GRPC_PORT", String.valueOf(this.grpcPort));
            this.withEnv("GRPC_TLS_PORT", String.valueOf(this.grpcsPort));
        }
        this.withEnv("YDB_USE_IN_MEMORY_PDISKS", "true");
        if (this.env.dockerFeatures() != null && !this.env.dockerFeatures().isEmpty()) {
            this.withEnv("YDB_FEATURE_FLAGS", this.env.dockerFeatures());
        }
        this.withReuse(this.env.dockerReuse());
        String id = "ydb-" + UUID.randomUUID();
        this.withLabel("com.docker.ydb.id", id);
        this.withCreateContainerCmdModifier(modifier -> modifier.withName(id).withHostName(this.getHost()));
        this.waitingFor((WaitStrategy)Wait.forHealthcheck());
        ResourceReaper.instance().registerLabelsFilterForCleanup(Collections.singletonMap("com.docker.ydb.id", id));
    }

    public EndpointRecord nonSecureEndpoint() {
        return new EndpointRecord(this.getHost(), this.getMappedPort(this.grpcPort).intValue());
    }

    public EndpointRecord secureEndpoint() {
        return new EndpointRecord(this.getHost(), this.getMappedPort(this.grpcsPort).intValue());
    }

    public byte[] pemCert() {
        return (byte[])this.copyFileFromContainer(this.env.dockerPemPath(), is -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)baos);
            return baos.toByteArray();
        });
    }

    public String database() {
        return this.env.dockerDatabase();
    }
}

