/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.docker;

import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import org.testcontainers.utility.TestcontainersConfiguration;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.test.integration.YdbEnvironment;
import tech.ydb.test.integration.YdbHelper;
import tech.ydb.test.integration.YdbHelperFactory;
import tech.ydb.test.integration.docker.GrpcProxyServer;
import tech.ydb.test.integration.docker.YdbDockerContainer;

public class ProxedDockerHelperFactory
extends YdbHelperFactory {
    private final YdbEnvironment env;
    private final YdbDockerContainer container;

    public ProxedDockerHelperFactory(YdbEnvironment env) {
        this(env, new YdbDockerContainer(env, null));
    }

    public ProxedDockerHelperFactory(YdbEnvironment env, YdbDockerContainer container) {
        this.env = env;
        this.container = container;
        this.container.init();
    }

    @Override
    public YdbHelper createHelper() {
        this.container.start();
        ManagedChannel channel = Grpc.newChannelBuilder((String)this.container.nonSecureEndpoint().getHostAndPort(), (ChannelCredentials)InsecureChannelCredentials.create()).build();
        final GrpcProxyServer server = new GrpcProxyServer(channel, 0);
        return new YdbHelper(){

            @Override
            public GrpcTransport createTransport() {
                return GrpcTransport.forEndpoint((String)this.endpoint(), (String)ProxedDockerHelperFactory.this.container.database()).build();
            }

            @Override
            public String endpoint() {
                return server.endpoint().getHostAndPort();
            }

            @Override
            public String database() {
                return ProxedDockerHelperFactory.this.container.database();
            }

            @Override
            public boolean useTls() {
                return false;
            }

            @Override
            public String authToken() {
                return null;
            }

            @Override
            public byte[] pemCert() {
                return null;
            }

            @Override
            public void close() {
                server.close();
                if (ProxedDockerHelperFactory.this.env.dockerReuse() && TestcontainersConfiguration.getInstance().environmentSupportsReuse()) {
                    return;
                }
                ProxedDockerHelperFactory.this.container.stop();
                ProxedDockerHelperFactory.this.container.close();
            }
        };
    }
}

