/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.docker;

import org.testcontainers.utility.TestcontainersConfiguration;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.test.integration.YdbEnvironment;
import tech.ydb.test.integration.YdbHelper;
import tech.ydb.test.integration.YdbHelperFactory;
import tech.ydb.test.integration.docker.YdbDockerContainer;
import tech.ydb.test.integration.utils.PortsGenerator;

public class DockerHelperFactory
extends YdbHelperFactory {
    private final YdbEnvironment env;
    private final YdbDockerContainer container;

    public DockerHelperFactory(YdbEnvironment env) {
        this(env, new YdbDockerContainer(env, new PortsGenerator()));
    }

    public DockerHelperFactory(YdbEnvironment env, YdbDockerContainer container) {
        this.env = env;
        this.container = container;
        this.container.init();
    }

    @Override
    public YdbHelper createHelper() {
        this.container.start();
        return new YdbHelper(){

            @Override
            public GrpcTransport createTransport() {
                GrpcTransportBuilder builder = GrpcTransport.forEndpoint((String)this.endpoint(), (String)DockerHelperFactory.this.container.database());
                if (DockerHelperFactory.this.env.ydbUseTls()) {
                    builder.withSecureConnection(DockerHelperFactory.this.container.pemCert());
                }
                return builder.build();
            }

            @Override
            public String endpoint() {
                EndpointRecord endpoint = DockerHelperFactory.this.env.ydbUseTls() ? DockerHelperFactory.this.container.secureEndpoint() : DockerHelperFactory.this.container.nonSecureEndpoint();
                return endpoint.getHostAndPort();
            }

            @Override
            public String database() {
                return DockerHelperFactory.this.container.database();
            }

            @Override
            public boolean useTls() {
                return DockerHelperFactory.this.env.ydbUseTls();
            }

            @Override
            public String authToken() {
                return null;
            }

            @Override
            public byte[] pemCert() {
                return DockerHelperFactory.this.container.pemCert();
            }

            @Override
            public void close() {
                if (DockerHelperFactory.this.env.dockerReuse() && TestcontainersConfiguration.getInstance().environmentSupportsReuse()) {
                    return;
                }
                DockerHelperFactory.this.container.stop();
                DockerHelperFactory.this.container.close();
            }
        };
    }
}

