/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.docker;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.UUID;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.utility.ResourceReaper;
import tech.ydb.test.integration.YdbEnvironment;
import tech.ydb.test.integration.utils.PortsGenerator;

public class YdbDockerContainer
extends GenericContainer<YdbDockerContainer> {
    private final YdbEnvironment env;
    private final int grpcsPort;
    private final int grpcPort;

    public YdbDockerContainer(YdbEnvironment env, PortsGenerator portsGenerator) {
        super(env.dockerImage());
        this.env = env;
        this.grpcsPort = portsGenerator.findAvailablePort();
        this.grpcPort = portsGenerator.findAvailablePort();
    }

    public void init() {
        this.addExposedPort(this.grpcPort);
        this.addExposedPort(this.grpcsPort);
        this.addFixedExposedPort(this.grpcsPort, this.grpcsPort);
        this.addFixedExposedPort(this.grpcPort, this.grpcPort);
        this.withEnv("GRPC_PORT", String.valueOf(this.grpcPort));
        this.withEnv("GRPC_TLS_PORT", String.valueOf(this.grpcsPort));
        this.withEnv("YDB_USE_IN_MEMORY_PDISKS", "true");
        this.withReuse(this.env.dockerReuse());
        String id = "ydb-" + UUID.randomUUID();
        this.withLabel("com.docker.ydb.id", id);
        this.withCreateContainerCmdModifier(modifier -> modifier.withName(id).withHostName(this.getHost()));
        this.waitingFor((WaitStrategy)Wait.forHealthcheck());
        ResourceReaper.instance().registerLabelsFilterForCleanup(Collections.singletonMap("com.docker.ydb.id", id));
    }

    public String nonSecureEndpoint() {
        return String.format("%s:%s", this.getHost(), this.grpcPort);
    }

    public String secureEndpoint() {
        return String.format("%s:%s", this.getHost(), this.grpcsPort);
    }

    public byte[] pemCert() {
        return (byte[])this.copyFileFromContainer(this.env.dockerPemPath(), is -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)baos);
            return baos.toByteArray();
        });
    }

    public String database() {
        return this.env.dockerDatabase();
    }
}

