/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.utils;

import io.grpc.MethodDescriptor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ydb.core.Result;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;

public abstract class ProxyGrpcTransport
implements GrpcTransport {
    protected abstract GrpcTransport origin();

    private GrpcTransport checked() {
        GrpcTransport check = this.origin();
        if (check == null) {
            throw new NullPointerException("Can't proxy method of null");
        }
        return check;
    }

    public ScheduledExecutorService getScheduler() {
        return this.checked().getScheduler();
    }

    public <ReqT, RespT> CompletableFuture<Result<RespT>> unaryCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings, ReqT request) {
        return this.checked().unaryCall(method, settings, request);
    }

    public <ReqT, RespT> GrpcReadStream<RespT> readStreamCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings, ReqT request) {
        return this.checked().readStreamCall(method, settings, request);
    }

    public <ReqT, RespT> GrpcReadWriteStream<RespT, ReqT> readWriteStreamCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings) {
        return this.checked().readWriteStreamCall(method, settings);
    }

    public String getDatabase() {
        return this.checked().getDatabase();
    }

    public void close() {
    }
}

