/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.integration.external;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.auth.TokenAuthProvider;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.test.integration.YdbEnvironment;
import tech.ydb.test.integration.YdbHelper;
import tech.ydb.test.integration.YdbHelperFactory;

public class ExternalHelperFactory
extends YdbHelperFactory {
    private final YdbEnvironment env;

    public ExternalHelperFactory(YdbEnvironment env) {
        this.env = env;
    }

    @Override
    public YdbHelper createHelper() {
        return new YdbHelper(){

            @Override
            public GrpcTransport createTransport() {
                GrpcTransportBuilder builder = GrpcTransport.forEndpoint((String)this.endpoint(), (String)this.database());
                if (this.authToken() != null) {
                    builder.withAuthProvider((AuthRpcProvider)new TokenAuthProvider(this.authToken()));
                }
                if (this.useTls()) {
                    builder.withSecureConnection(this.pemCert());
                }
                return builder.build();
            }

            @Override
            public String endpoint() {
                return ExternalHelperFactory.this.env.ydbEndpoint();
            }

            @Override
            public String database() {
                return ExternalHelperFactory.this.env.ydbDatabase();
            }

            @Override
            public boolean useTls() {
                return ExternalHelperFactory.this.env.ydbUseTls();
            }

            @Override
            public String authToken() {
                return ExternalHelperFactory.this.env.ydbAuthToken();
            }

            @Override
            public byte[] pemCert() {
                if (ExternalHelperFactory.this.env.ydbPemCert() != null) {
                    try {
                        return Files.asByteSource((File)new File(ExternalHelperFactory.this.env.ydbPemCert())).read();
                    }
                    catch (IOException ex) {
                        logger.warn("can't read pem cert {}", (Object)ExternalHelperFactory.this.env.ydbPemCert(), (Object)ex);
                    }
                }
                return null;
            }

            @Override
            public void close() {
            }
        };
    }
}

