/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import tech.ydb.jdbc.settings.YdbLookup;
import tech.ydb.jdbc.settings.YdbValue;

class YdbProperty<T> {
    private final String name;
    private final String description;
    private final String defaultValue;
    private final Class<T> clazz;
    private final Parser<T> parser;

    private YdbProperty(String name, String description, String defaultValue, Class<T> clazz, Parser<T> parser) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
        this.defaultValue = defaultValue;
        this.clazz = clazz;
        this.parser = Objects.requireNonNull(parser);
    }

    public String getName() {
        return this.name;
    }

    public YdbValue<T> readValue(Properties props) throws SQLException {
        Object value = props.get(this.name);
        if (value == null) {
            if (this.defaultValue == null || this.defaultValue.isEmpty()) {
                return new YdbValue<Object>(false, "", null);
            }
            return new YdbValue<T>(false, this.defaultValue, this.parser.parse(this.defaultValue));
        }
        if (value instanceof String) {
            try {
                String stringValue = (String)value;
                return new YdbValue<T>(true, stringValue, this.parser.parse(stringValue));
            }
            catch (RuntimeException e) {
                throw new SQLException("Unable to convert property " + this.name + ": " + e.getMessage(), e);
            }
        }
        if (this.clazz.isAssignableFrom(value.getClass())) {
            T typed = this.clazz.cast(value);
            return new YdbValue<T>(true, typed.toString(), typed);
        }
        throw new SQLException("Invalid object property " + this.name + ", must be " + this.clazz + ", got " + value.getClass());
    }

    DriverPropertyInfo toInfo(Properties values) throws SQLException {
        YdbValue<T> value = this.readValue(values);
        DriverPropertyInfo info = new DriverPropertyInfo(this.name, value.rawValue());
        info.description = this.description;
        info.required = false;
        return info;
    }

    public static YdbProperty<String> string(String name, String description) {
        return YdbProperty.string(name, description, null);
    }

    public static YdbProperty<String> string(String name, String description, String defaultValue) {
        return new YdbProperty<String>(name, description, defaultValue, String.class, v -> v);
    }

    public static YdbProperty<Boolean> bool(String name, String description, boolean defaultValue) {
        return YdbProperty.bool(name, description, String.valueOf(defaultValue));
    }

    public static YdbProperty<Boolean> bool(String name, String description) {
        return YdbProperty.bool(name, description, null);
    }

    private static YdbProperty<Boolean> bool(String name, String description, String defaultValue) {
        return new YdbProperty<Boolean>(name, description, defaultValue, Boolean.class, Boolean::valueOf);
    }

    public static YdbProperty<Integer> integer(String name, String description) {
        return YdbProperty.integer(name, description, null);
    }

    public static YdbProperty<Integer> integer(String name, String description, int defaultValue) {
        return YdbProperty.integer(name, description, String.valueOf(defaultValue));
    }

    private static YdbProperty<Integer> integer(String name, String description, String defaultValue) {
        return new YdbProperty<Integer>(name, description, defaultValue, Integer.class, value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unable to parse value [" + value + "] as Integer: " + e.getMessage(), e);
            }
        });
    }

    public static <E extends Enum<E>> YdbProperty<E> enums(String name, Class<E> clazz, String description) {
        return YdbProperty.enums(name, description, clazz, null);
    }

    public static <E extends Enum<E>> YdbProperty<E> enums(String name, Class<E> clazz, String description, E def) {
        return YdbProperty.enums(name, description, clazz, def.toString());
    }

    private static <E extends Enum<E>> YdbProperty<E> enums(String name, String desc, Class<E> clazz, String def) {
        return new YdbProperty<Enum>(name, desc, def, clazz, value -> {
            for (Enum v : (Enum[])clazz.getEnumConstants()) {
                if (!v.name().equalsIgnoreCase(value)) continue;
                return v;
            }
            return null;
        });
    }

    public static YdbProperty<Duration> duration(String name, String description) {
        return YdbProperty.duration(name, description, null);
    }

    public static YdbProperty<Duration> duration(String name, String description, String defaultValue) {
        return new YdbProperty<Duration>(name, description, defaultValue, Duration.class, value -> {
            String targetValue = "PT" + value.replace(" ", "").toUpperCase(Locale.ROOT);
            try {
                return Duration.parse(targetValue);
            }
            catch (DateTimeParseException e) {
                throw new RuntimeException("Unable to parse value [" + value + "] -> [" + targetValue + "] as Duration: " + e.getMessage(), e);
            }
        });
    }

    public static YdbProperty<byte[]> bytes(String name, String description) {
        return new YdbProperty<byte[]>(name, description, null, byte[].class, YdbLookup::byteFileReference);
    }

    public static YdbProperty<String> content(String name, String description) {
        return new YdbProperty<String>(name, description, null, String.class, YdbLookup::stringFileReference);
    }

    private static interface Parser<T> {
        public T parse(String var1) throws SQLException;
    }
}

