/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.sql.SQLException;
import java.util.List;
import tech.ydb.jdbc.query.QueryStatement;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQueryParser;
import tech.ydb.jdbc.query.YqlBatcher;
import tech.ydb.jdbc.settings.YdbQueryProperties;

public class YdbQuery {
    private final String originQuery;
    private final String preparedYQL;
    private final List<QueryStatement> statements;
    private final YqlBatcher batch;
    private final QueryType type;
    private final boolean isPlainYQL;

    YdbQuery(String originQuery, String preparedYQL, List<QueryStatement> stats, QueryType type) {
        this(originQuery, preparedYQL, stats, null, type);
    }

    YdbQuery(String originQuery, String preparedYQL, List<QueryStatement> stats, YqlBatcher batch, QueryType type) {
        this.originQuery = originQuery;
        this.preparedYQL = preparedYQL;
        this.statements = stats;
        this.type = type;
        this.batch = batch;
        boolean hasJdbcParamters = false;
        for (QueryStatement st : this.statements) {
            hasJdbcParamters = hasJdbcParamters || !st.getParams().isEmpty();
        }
        this.isPlainYQL = !hasJdbcParamters;
    }

    public QueryType getType() {
        return this.type;
    }

    public YqlBatcher getYqlBatcher() {
        return this.batch;
    }

    public boolean isPlainYQL() {
        return this.isPlainYQL;
    }

    public String getOriginQuery() {
        return this.originQuery;
    }

    public String getPreparedYql() {
        return this.preparedYQL;
    }

    public List<QueryStatement> getStatements() {
        return this.statements;
    }

    public static YdbQuery parseQuery(String query, YdbQueryProperties opts) throws SQLException {
        YdbQueryParser parser = new YdbQueryParser(opts.isDetectQueryType(), opts.isDetectJdbcParameters());
        String preparedYQL = parser.parseSQL(query);
        QueryType type = opts.getForcedQueryType();
        if (type == null) {
            type = parser.detectQueryType();
            if (opts.isForcedScanAndBulks() && type != QueryType.SCHEME_QUERY && type != QueryType.EXPLAIN_QUERY) {
                if (parser.getYqlBatcher().isValidBatch()) {
                    parser.getYqlBatcher().setForcedUpsert();
                    type = QueryType.BULK_QUERY;
                } else {
                    type = QueryType.SCAN_QUERY;
                }
            }
        }
        if (parser.getYqlBatcher().isValidBatch()) {
            return new YdbQuery(query, preparedYQL, parser.getStatements(), parser.getYqlBatcher(), type);
        }
        return new YdbQuery(query, preparedYQL, parser.getStatements(), type);
    }
}

