/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Logger;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.context.QueryStat;
import tech.ydb.jdbc.context.StaticQueryResult;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.impl.YdbQueryResult;
import tech.ydb.jdbc.impl.YdbStaticResultSet;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.settings.FakeTxMode;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.ListValue;

public abstract class BaseYdbStatement
implements YdbStatement {
    private final YdbConnection connection;
    private final YdbValidator validator;
    private final int resultSetType;
    private final int maxRows;
    private final FakeTxMode scanQueryTxMode;
    private final FakeTxMode schemeQueryTxMode;
    private final FakeTxMode bulkQueryTxMode;
    private YdbQueryResult state = YdbQueryResult.EMPTY;
    private int queryTimeout;
    private boolean isPoolable;
    private boolean isClosed = false;

    public BaseYdbStatement(Logger logger, YdbConnection connection, int resultSetType, boolean isPoolable) {
        this.connection = Objects.requireNonNull(connection);
        this.validator = new YdbValidator(logger);
        this.resultSetType = resultSetType;
        this.isPoolable = isPoolable;
        YdbOperationProperties props = connection.getCtx().getOperationProperties();
        this.queryTimeout = (int)props.getQueryTimeout().getSeconds();
        this.maxRows = props.getMaxRows();
        this.scanQueryTxMode = props.getScanQueryTxMode();
        this.schemeQueryTxMode = props.getSchemeQueryTxMode();
        this.bulkQueryTxMode = props.getBulkQueryTxMode();
    }

    @Override
    public YdbValidator getValidator() {
        return this.validator;
    }

    @Override
    public YdbConnection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        this.clearBatch();
        this.state.close();
        this.state = YdbQueryResult.EMPTY;
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.validator.toSQLWarnings();
    }

    @Override
    public void clearWarnings() {
        this.validator.clearWarnings();
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ensureOpened();
        this.queryTimeout = seconds;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.isPoolable = poolable;
    }

    @Override
    public boolean isPoolable() {
        return this.isPoolable;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public YdbResultSet getResultSet() throws SQLException {
        this.ensureOpened();
        return this.state.getCurrentResultSet();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.ensureOpened();
        return this.state.getMoreResults(current);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureOpened();
        return this.state.getUpdateCount();
    }

    private void ensureOpened() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public void waitReady() throws SQLException {
        this.state.close();
    }

    protected void cleanState() throws SQLException {
        this.ensureOpened();
        this.state.close();
        this.state = YdbQueryResult.EMPTY;
        this.clearWarnings();
    }

    protected boolean updateState(YdbQueryResult result) throws SQLException {
        this.state = result == null ? YdbQueryResult.EMPTY : result;
        return this.state.hasResultSets();
    }

    protected YdbQueryResult executeBulkUpsert(YdbQuery query, String tablePath, ListValue rows) throws SQLException {
        this.connection.getExecutor().ensureOpened();
        if (this.connection.getExecutor().isInsideTransaction()) {
            switch (this.bulkQueryTxMode) {
                case FAKE_TX: {
                    break;
                }
                case SHADOW_COMMIT: {
                    this.connection.commit();
                    break;
                }
                default: {
                    throw new SQLException("Bulk upsert query cannot be executed inside active transaction. This behavior may be changed by property bulkUpsertQueryTxMode");
                }
            }
        }
        return this.connection.getExecutor().executeBulkUpsert(this, query, tablePath, rows);
    }

    protected YdbQueryResult executeExplainQuery(YdbQuery query) throws SQLException {
        this.connection.getExecutor().ensureOpened();
        return this.connection.getExecutor().executeExplainQuery(this, query);
    }

    protected YdbQueryResult executeDataQuery(YdbQuery query, String yql, Params params) throws SQLException {
        this.connection.getExecutor().ensureOpened();
        YdbContext ctx = this.connection.getCtx();
        if (ctx.queryStatsEnabled()) {
            if (QueryStat.isPrint(yql)) {
                YdbStaticResultSet rs = new YdbStaticResultSet((YdbStatement)this, QueryStat.toResultSetReader(ctx.getQueryStats()));
                return new StaticQueryResult(query, Collections.singletonList(rs));
            }
            if (QueryStat.isReset(yql)) {
                this.getConnection().getCtx().resetQueryStats();
                return null;
            }
        }
        ctx.traceQuery(query, yql);
        return this.connection.getExecutor().executeDataQuery(this, query, yql, params, this.getQueryTimeout(), this.isPoolable());
    }

    protected YdbQueryResult executeSchemeQuery(YdbQuery query) throws SQLException {
        this.connection.getExecutor().ensureOpened();
        if (this.connection.getExecutor().isInsideTransaction()) {
            switch (this.schemeQueryTxMode) {
                case FAKE_TX: {
                    break;
                }
                case SHADOW_COMMIT: {
                    this.connection.commit();
                    break;
                }
                default: {
                    throw new SQLException("Scheme query cannot be executed inside active transaction. This behavior may be changed by property schemeQueryTxMode");
                }
            }
        }
        return this.connection.getExecutor().executeSchemeQuery(this, query);
    }

    protected YdbQueryResult executeScanQuery(YdbQuery query, String yql, Params params) throws SQLException {
        this.connection.getExecutor().ensureOpened();
        if (this.connection.getExecutor().isInsideTransaction()) {
            switch (this.scanQueryTxMode) {
                case FAKE_TX: {
                    break;
                }
                case SHADOW_COMMIT: {
                    this.connection.commit();
                    break;
                }
                default: {
                    throw new SQLException("Scan query cannot be executed inside active transaction. This behavior may be changed by property scanQueryTxMode");
                }
            }
        }
        return this.connection.getExecutor().executeScanQuery(this, query, yql, params);
    }

    @Override
    public void setCursorName(String name) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Named cursors are not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpened();
        return this.getMoreResults(2);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1002) {
            throw new SQLException("Direction is not supported: " + direction);
        }
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return this.getMaxRows();
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }
}

