/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.common.ColumnInfo;
import tech.ydb.jdbc.exception.ExceptionFactory;
import tech.ydb.jdbc.impl.BaseYdbResultSet;
import tech.ydb.jdbc.impl.YdbQueryResult;
import tech.ydb.jdbc.query.QueryStatement;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.query.QueryStream;
import tech.ydb.query.result.QueryResultPart;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;

public class StreamQueryResult
implements YdbQueryResult {
    private static final int DDL_EXPRESSION = -1;
    private static final int UPDATE_EXPRESSION = -2;
    private final String msg;
    private final YdbStatement statement;
    private final Runnable stopRunnable;
    private final CompletableFuture<Status> finishFuture = new CompletableFuture();
    private final CompletableFuture<Result<StreamQueryResult>> startFuture = new CompletableFuture();
    private final int[] resultIndexes;
    private final List<CompletableFuture<Result<LazyResultSet>>> resultFutures = new ArrayList<CompletableFuture<Result<LazyResultSet>>>();
    private int resultIndex = 0;

    public StreamQueryResult(String msg, YdbStatement statement, YdbQuery query, Runnable stopRunnable) {
        this.msg = msg;
        this.statement = statement;
        this.stopRunnable = stopRunnable;
        this.resultIndexes = new int[query.getStatements().size()];
        int idx = 0;
        for (QueryStatement exp : query.getStatements()) {
            if (exp.isDDL()) {
                this.resultIndexes[idx++] = -1;
                continue;
            }
            if (exp.hasUpdateCount()) {
                this.resultIndexes[idx++] = -2;
                continue;
            }
            if (!exp.hasResults()) continue;
            this.resultIndexes[idx++] = this.resultFutures.size();
            this.resultFutures.add(new CompletableFuture());
        }
    }

    public CompletableFuture<Result<StreamQueryResult>> execute(QueryStream stream, Runnable finish) {
        ((CompletableFuture)((CompletableFuture)stream.execute((QueryStream.PartsHandler)new QueryPartsHandler()).thenApply(Result::getStatus)).whenComplete(this::onStreamFinished)).thenRun(finish);
        return this.startFuture;
    }

    public CompletableFuture<Result<StreamQueryResult>> execute(GrpcReadStream<ResultSetReader> stream) {
        stream.start(rsr -> this.onResultSet(0, (ResultSetReader)rsr)).whenComplete(this::onStreamFinished);
        return this.startFuture;
    }

    private void onStreamFinished(Status status, Throwable th) {
        if (th != null) {
            this.finishFuture.completeExceptionally(th);
            for (CompletableFuture<Result<LazyResultSet>> future : this.resultFutures) {
                future.completeExceptionally(th);
            }
            this.startFuture.completeExceptionally(th);
        }
        if (status != null) {
            this.finishFuture.complete(status);
            if (status.isSuccess()) {
                for (CompletableFuture<Result<LazyResultSet>> future : this.resultFutures) {
                    future.complete((Result<LazyResultSet>)Result.success((Object)new LazyResultSet(this.statement, new ColumnInfo[0]), (Status)status));
                }
                this.startFuture.complete((Result<StreamQueryResult>)Result.success((Object)this));
            } else {
                for (CompletableFuture<Result<LazyResultSet>> future : this.resultFutures) {
                    future.complete((Result<LazyResultSet>)Result.fail((Status)status));
                }
                this.startFuture.complete((Result<StreamQueryResult>)Result.fail((Status)status));
            }
        }
        for (CompletableFuture<Result<LazyResultSet>> future : this.resultFutures) {
            Result<LazyResultSet> rs;
            if (future.isCompletedExceptionally() || !(rs = future.join()).isSuccess()) continue;
            ((LazyResultSet)rs.getValue()).complete();
        }
    }

    @Override
    public void close() throws SQLException {
        Status status = this.finishFuture.join();
        if (!status.isSuccess()) {
            throw ExceptionFactory.createException("Cannot execute '" + this.msg + "' with " + status, new UnexpectedResultException("Unexpected status", status));
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.resultIndex >= this.resultIndexes.length) {
            return -1;
        }
        int index = this.resultIndexes[this.resultIndex];
        if (index == -1) {
            return 0;
        }
        if (index == -2) {
            return 1;
        }
        return -1;
    }

    @Override
    public YdbResultSet getCurrentResultSet() throws SQLException {
        if (this.resultIndex >= this.resultIndexes.length) {
            return null;
        }
        int index = this.resultIndexes[this.resultIndex];
        if (index < 0 || index >= this.resultFutures.size()) {
            return null;
        }
        try {
            return (YdbResultSet)this.resultFutures.get(index).join().getValue();
        }
        catch (UnexpectedResultException ex) {
            throw ExceptionFactory.createException("Cannot call '" + this.msg + "' with " + ex.getStatus(), ex);
        }
    }

    @Override
    public boolean hasResultSets() throws SQLException {
        if (this.resultIndex >= this.resultIndexes.length) {
            return false;
        }
        return this.resultIndexes[this.resultIndex] >= 0;
    }

    private void closeResultSet(int index) throws SQLException {
        try {
            CompletableFuture<Result<LazyResultSet>> future = this.resultFutures.get(index);
            if (future != null) {
                ((LazyResultSet)future.join().getValue()).close();
            }
        }
        catch (UnexpectedResultException ex) {
            throw ExceptionFactory.createException("Cannot call '" + this.msg + "' with " + ex.getStatus(), ex);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.resultFutures == null || this.resultIndex >= this.resultFutures.size()) {
            return false;
        }
        switch (current) {
            case 2: {
                break;
            }
            case 1: {
                this.closeResultSet(this.resultIndex);
                break;
            }
            case 3: {
                for (int idx = 0; idx <= this.resultIndex; ++idx) {
                    this.closeResultSet(this.resultIndex);
                }
                break;
            }
            default: {
                throw new SQLException("ResultSet mode is not supported: " + current);
            }
        }
        ++this.resultIndex;
        return this.hasResultSets();
    }

    private void onResultSet(int index, ResultSetReader rsr) {
        Result<LazyResultSet> res;
        CompletableFuture<Result<LazyResultSet>> future = this.resultFutures.get(index);
        if (!future.isDone()) {
            ColumnInfo[] columns = ColumnInfo.fromResultSetReader(rsr);
            future.complete((Result<LazyResultSet>)Result.success((Object)new LazyResultSet(this.statement, columns)));
        }
        if ((res = future.join()).isSuccess()) {
            try {
                ((LazyResultSet)res.getValue()).addResultSet(rsr);
            }
            catch (InterruptedException ex) {
                this.stopRunnable.run();
            }
        }
    }

    private class LazyResultSet
    extends BaseYdbResultSet {
        private final BlockingQueue<ResultSetReader> readers;
        private final AtomicLong rowsCount;
        private volatile boolean isCompleted;
        private volatile boolean isClosed;
        private ResultSetReader current;
        private int rowIndex;

        LazyResultSet(YdbStatement statement, ColumnInfo[] columns) {
            super(statement, columns);
            this.readers = new ArrayBlockingQueue<ResultSetReader>(5);
            this.rowsCount = new AtomicLong();
            this.isCompleted = false;
            this.isClosed = false;
            this.current = null;
            this.rowIndex = 0;
        }

        public void cleanQueue() {
            boolean isEmpty = false;
            while (!isEmpty) {
                isEmpty = this.readers.poll() == null;
            }
        }

        public void addResultSet(ResultSetReader rsr) throws InterruptedException {
            if (this.isClosed) {
                return;
            }
            if (this.readers.offer(rsr, 60L, TimeUnit.SECONDS)) {
                this.rowsCount.addAndGet(rsr.getRowCount());
            }
            if (this.isClosed) {
                this.cleanQueue();
            }
        }

        @Override
        protected ValueReader getValue(int columnIndex) throws SQLException {
            if (this.current == null) {
                throw new SQLException("Current row index is out of bounds: " + this.rowIndex);
            }
            return this.current.getColumn(columnIndex);
        }

        @Override
        public boolean next() throws SQLException {
            while (!this.isClosed) {
                if (this.current != null && this.current.next()) {
                    ++this.rowIndex;
                    return true;
                }
                if (this.isCompleted && this.readers.isEmpty()) {
                    this.current = null;
                    if (this.rowsCount.get() > 0L) {
                        this.rowIndex = this.rowsCount.intValue() + 1;
                    }
                    return false;
                }
                try {
                    this.current = this.readers.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw new SQLException(ex);
                }
            }
            return false;
        }

        public void complete() {
            if (this.isCompleted) {
                return;
            }
            this.isCompleted = true;
        }

        @Override
        public void close() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.current = null;
            this.cleanQueue();
        }

        @Override
        public int getRow() throws SQLException {
            return this.rowIndex;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.isClosed;
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            return this.rowsCount.get() > 0L && this.rowIndex < 1;
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return this.isCompleted && this.rowsCount.get() > 0L && this.rowIndex > this.rowsCount.intValue();
        }

        @Override
        public boolean isFirst() throws SQLException {
            return this.rowIndex == 1;
        }

        @Override
        public boolean isLast() throws SQLException {
            return this.isCompleted && this.rowsCount.get() > 0L && this.rowIndex == this.rowsCount.intValue();
        }

        @Override
        public void beforeFirst() throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public void afterLast() throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public boolean first() throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public boolean last() throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public boolean absolute(int row) throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public boolean relative(int rows) throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public boolean previous() throws SQLException {
            throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            if (direction != 1000) {
                throw new SQLFeatureNotSupportedException("ResultSet in TYPE_FORWARD_ONLY mode");
            }
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return 1000;
        }
    }

    private class QueryPartsHandler
    implements QueryStream.PartsHandler {
        private QueryPartsHandler() {
        }

        public void onIssues(Issue[] issues) {
            StreamQueryResult.this.startFuture.complete(Result.success((Object)StreamQueryResult.this));
            StreamQueryResult.this.statement.getValidator().addStatusIssues(Arrays.asList(issues));
        }

        public void onNextPart(QueryResultPart part) {
            StreamQueryResult.this.startFuture.complete(Result.success((Object)StreamQueryResult.this));
            StreamQueryResult.this.onResultSet((int)part.getResultSetIndex(), part.getResultSetReader());
        }
    }
}

