/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.ydb.common.transaction.TxMode;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.context.BaseYdbExecutor;
import tech.ydb.jdbc.context.StaticQueryResult;
import tech.ydb.jdbc.context.StreamQueryResult;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.exception.ExceptionFactory;
import tech.ydb.jdbc.impl.YdbQueryResult;
import tech.ydb.jdbc.impl.YdbStaticResultSet;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.query.QueryClient;
import tech.ydb.query.QuerySession;
import tech.ydb.query.QueryStream;
import tech.ydb.query.QueryTransaction;
import tech.ydb.query.result.QueryInfo;
import tech.ydb.query.result.QueryResultPart;
import tech.ydb.query.settings.CommitTransactionSettings;
import tech.ydb.query.settings.ExecuteQuerySettings;
import tech.ydb.query.settings.QueryExecMode;
import tech.ydb.query.settings.RollbackTransactionSettings;
import tech.ydb.query.tools.QueryReader;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;

public class QueryServiceExecutor
extends BaseYdbExecutor {
    private static final Logger LOGGER = Logger.getLogger(QueryServiceExecutor.class.getName());
    private final Duration sessionTimeout;
    private final QueryClient queryClient;
    private int transactionLevel;
    private boolean isReadOnly;
    private boolean isAutoCommit;
    private TxMode txMode;
    private QueryTransaction tx;
    private boolean isClosed;

    public QueryServiceExecutor(YdbContext ctx, int transactionLevel, boolean autoCommit) throws SQLException {
        super(ctx);
        this.sessionTimeout = ctx.getOperationProperties().getSessionTimeout();
        this.queryClient = ctx.getQueryClient();
        this.transactionLevel = transactionLevel;
        this.isReadOnly = transactionLevel != 8;
        this.isAutoCommit = autoCommit;
        this.txMode = QueryServiceExecutor.txMode(transactionLevel, this.isReadOnly);
        this.tx = null;
        this.isClosed = false;
    }

    protected QuerySession createNewQuerySession(YdbValidator validator) throws SQLException {
        try {
            Result result = (Result)this.queryClient.createSession(this.sessionTimeout).join();
            validator.addStatusIssues(result.getStatus());
            QuerySession session = (QuerySession)result.getValue();
            LOGGER.log(Level.FINEST, "Acquired session {0}", session);
            return session;
        }
        catch (UnexpectedResultException ex) {
            throw ExceptionFactory.createException("Cannot create session with " + ex.getStatus(), ex);
        }
    }

    @Override
    public void close() {
        this.cleanTx();
        this.isClosed = true;
    }

    private void cleanTx() {
        if (this.tx != null) {
            LOGGER.log(Level.FINEST, "Released session {0}", this.tx.getSession());
            this.tx.getSession().close();
            this.tx = null;
        }
    }

    @Override
    public void setTransactionLevel(int level) throws SQLException {
        if (level == this.transactionLevel) {
            return;
        }
        if (this.tx != null && this.tx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }
        this.isReadOnly = this.isReadOnly || level != 8;
        this.transactionLevel = level;
        this.txMode = QueryServiceExecutor.txMode(this.transactionLevel, this.isReadOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly == this.isReadOnly) {
            return;
        }
        if (this.tx != null && this.tx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change read-only attribute inside a transaction");
        }
        this.isReadOnly = readOnly;
        this.txMode = QueryServiceExecutor.txMode(this.transactionLevel, this.isReadOnly);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.isAutoCommit) {
            return;
        }
        if (this.tx != null && this.tx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }
        this.isAutoCommit = autoCommit;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public String txID() {
        return this.tx != null ? this.tx.getId() : null;
    }

    @Override
    public boolean isInsideTransaction() throws SQLException {
        this.ensureOpened();
        return this.tx != null && this.tx.isActive();
    }

    @Override
    public boolean isAutoCommit() throws SQLException {
        this.ensureOpened();
        return this.isAutoCommit;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpened();
        return this.isReadOnly;
    }

    @Override
    public int transactionLevel() throws SQLException {
        this.ensureOpened();
        return this.transactionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        if (this.tx == null || !this.tx.isActive()) {
            return;
        }
        CommitTransactionSettings settings = ctx.withRequestTimeout(CommitTransactionSettings.newBuilder()).build();
        try {
            validator.clearWarnings();
            validator.call("Commit TxId: " + this.tx.getId(), () -> this.tx.commit(settings));
        }
        finally {
            this.cleanTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        if (this.tx == null || !this.tx.isActive()) {
            return;
        }
        RollbackTransactionSettings settings = ctx.withRequestTimeout(RollbackTransactionSettings.newBuilder()).build();
        try {
            validator.clearWarnings();
            validator.execute("Rollback TxId: " + this.tx.getId(), () -> this.tx.rollback(settings));
        }
        finally {
            this.cleanTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YdbQueryResult executeDataQuery(YdbStatement statement, YdbQuery query, String yql, Params params, long timeout, boolean keepInCache) throws SQLException {
        this.ensureOpened();
        YdbValidator validator = statement.getValidator();
        ExecuteQuerySettings.Builder builder = ExecuteQuerySettings.newBuilder();
        if (timeout > 0L) {
            builder = (ExecuteQuerySettings.Builder)builder.withRequestTimeout(timeout, TimeUnit.SECONDS);
        }
        ExecuteQuerySettings settings = builder.build();
        if (this.tx == null) {
            this.tx = this.createNewQuerySession(validator).createNewTransaction(this.txMode);
        }
        try {
            QueryReader result = (QueryReader)validator.call((Object)((Object)QueryType.DATA_QUERY) + " >>\n" + yql, () -> QueryReader.readFrom((QueryStream)this.tx.createQuery(yql, this.isAutoCommit, params, settings)));
            validator.addStatusIssues(result.getIssueList());
            ArrayList<YdbResultSet> readers = new ArrayList<YdbResultSet>();
            for (ResultSetReader rst : result) {
                readers.add(new YdbStaticResultSet(statement, rst));
            }
            StaticQueryResult staticQueryResult = new StaticQueryResult(query, readers);
            return staticQueryResult;
        }
        finally {
            if (!this.tx.isActive()) {
                this.cleanTx();
            }
        }
    }

    @Override
    public YdbQueryResult executeScanQuery(YdbStatement statement, YdbQuery query, String yql, Params params) throws SQLException {
        this.ensureOpened();
        YdbContext ctx = statement.getConnection().getCtx();
        YdbValidator validator = statement.getValidator();
        Duration scanQueryTimeout = ctx.getOperationProperties().getScanQueryTimeout();
        ExecuteQuerySettings settings = ((ExecuteQuerySettings.Builder)ExecuteQuerySettings.newBuilder().withRequestTimeout(scanQueryTimeout)).build();
        if (this.tx == null) {
            this.tx = this.createNewQuerySession(validator).createNewTransaction(this.txMode);
        }
        String msg = "STREAM_QUERY >>\n" + yql;
        return (YdbQueryResult)validator.call(msg, () -> {
            QueryStream stream = this.tx.createQuery(yql, this.isAutoCommit, params, settings);
            StreamQueryResult result = new StreamQueryResult(msg, statement, query, () -> ((QueryStream)stream).cancel());
            return result.execute(stream, () -> {
                if (!this.tx.isActive()) {
                    this.cleanTx();
                }
            });
        });
    }

    @Override
    public YdbQueryResult executeSchemeQuery(YdbStatement statement, YdbQuery query) throws SQLException {
        this.ensureOpened();
        String yql = query.getPreparedYql();
        YdbContext ctx = statement.getConnection().getCtx();
        YdbValidator validator = statement.getValidator();
        ExecuteQuerySettings settings = ctx.withRequestTimeout(ExecuteQuerySettings.newBuilder()).build();
        try (QuerySession session = this.createNewQuerySession(validator);){
            validator.call((Object)((Object)QueryType.SCHEME_QUERY) + " >>\n" + yql, () -> session.createQuery(yql, TxMode.NONE, Params.empty(), settings).execute((QueryStream.PartsHandler)new IssueHandler(validator)));
        }
        return new StaticQueryResult(query, Collections.emptyList());
    }

    @Override
    public YdbQueryResult executeExplainQuery(YdbStatement statement, YdbQuery query) throws SQLException {
        this.ensureOpened();
        String yql = query.getPreparedYql();
        YdbContext ctx = statement.getConnection().getCtx();
        YdbValidator validator = statement.getValidator();
        ExecuteQuerySettings settings = ctx.withRequestTimeout(ExecuteQuerySettings.newBuilder()).withExecMode(QueryExecMode.EXPLAIN).build();
        try (QuerySession session = this.createNewQuerySession(validator);){
            QueryInfo res = (QueryInfo)validator.call((Object)((Object)QueryType.EXPLAIN_QUERY) + " >>\n" + yql, () -> session.createQuery(yql, TxMode.NONE, Params.empty(), settings).execute((QueryStream.PartsHandler)new IssueHandler(validator)));
            if (!res.hasStats()) {
                throw new SQLException("No explain data");
            }
            StaticQueryResult staticQueryResult = new StaticQueryResult(statement, res.getStats().getQueryAst(), res.getStats().getQueryPlan());
            return staticQueryResult;
        }
    }

    @Override
    public boolean isValid(YdbValidator validator, int timeout) throws SQLException {
        this.ensureOpened();
        return true;
    }

    private static TxMode txMode(int level, boolean isReadOnly) throws SQLException {
        if (!isReadOnly) {
            if (level != 8) {
                throw new SQLException("Unsupported transaction level: " + level);
            }
            return TxMode.SERIALIZABLE_RW;
        }
        switch (level) {
            case 8: {
                return TxMode.SNAPSHOT_RO;
            }
            case 16: {
                return TxMode.ONLINE_RO;
            }
            case 17: {
                return TxMode.ONLINE_INCONSISTENT_RO;
            }
            case 32: {
                return TxMode.STALE_RO;
            }
        }
        throw new SQLException("Unsupported transaction level: " + level);
    }

    private class IssueHandler
    implements QueryStream.PartsHandler {
        private final YdbValidator validator;

        IssueHandler(YdbValidator validator) {
            this.validator = validator;
        }

        public void onIssues(Issue[] issues) {
            this.validator.addStatusIssues(Arrays.asList(issues));
        }

        public void onNextPart(QueryResultPart part) {
        }
    }
}

