/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import tech.ydb.jdbc.impl.YdbTypes;
import tech.ydb.table.result.PrimitiveReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class MappingGetters {
    private MappingGetters() {
    }

    static Getters buildGetters(Type type) {
        Type.Kind kind = type.getKind();
        String clazz = kind.toString();
        switch (kind) {
            case PRIMITIVE: {
                PrimitiveType id = (PrimitiveType)type;
                return new Getters(MappingGetters.valueToString(id), MappingGetters.valueToBoolean(id), MappingGetters.valueToByte(id), MappingGetters.valueToShort(id), MappingGetters.valueToInt(id), MappingGetters.valueToLong(id), MappingGetters.valueToFloat(id), MappingGetters.valueToDouble(id), MappingGetters.valueToBytes(id), MappingGetters.valueToObject(id), MappingGetters.valueToClass(id), MappingGetters.valueToInstant(id), MappingGetters.valueToNString(id), MappingGetters.valueToURL(id), MappingGetters.valueToBigDecimal(id), MappingGetters.valueToReader(id));
            }
            case DECIMAL: {
                return new Getters(value -> String.valueOf(value.getDecimal()), MappingGetters.castToBooleanNotSupported(clazz), MappingGetters.castToByteNotSupported(clazz), MappingGetters.castToShortNotSupported(clazz), value -> value.getDecimal().toBigInteger().intValue(), value -> value.getDecimal().toBigInteger().longValue(), value -> value.getDecimal().toBigDecimal().floatValue(), value -> value.getDecimal().toBigDecimal().doubleValue(), MappingGetters.castToBytesNotSupported(clazz), PrimitiveReader::getDecimal, MappingGetters.castToClassNotSupported(clazz), MappingGetters.castToInstantNotSupported(clazz), MappingGetters.castToNStringNotSupported(clazz), MappingGetters.castToUrlNotSupported(clazz), value -> value.getDecimal().toBigDecimal(), MappingGetters.castToReaderNotSupported(clazz));
            }
            case VOID: 
            case NULL: {
                return new Getters(value -> null, value -> false, value -> 0, value -> 0, value -> 0, value -> 0L, value -> 0.0f, value -> 0.0, value -> null, value -> null, new ValueToClass(){

                    @Override
                    public <T> T fromValue(ValueReader reader, Class<T> clazz) throws SQLException {
                        return null;
                    }
                }, value -> Instant.ofEpochSecond(0L), value -> null, value -> null, value -> null, value -> null);
            }
        }
        return new Getters(value -> String.valueOf(value.getValue()), MappingGetters.castToBooleanNotSupported(clazz), MappingGetters.castToByteNotSupported(clazz), MappingGetters.castToShortNotSupported(clazz), MappingGetters.castToIntNotSupported(clazz), MappingGetters.castToLongNotSupported(clazz), MappingGetters.castToFloatNotSupported(clazz), MappingGetters.castToDoubleNotSupported(clazz), MappingGetters.castToBytesNotSupported(clazz), ValueReader::getValue, MappingGetters.castToClassNotSupported(clazz), MappingGetters.castToInstantNotSupported(clazz), MappingGetters.castToNStringNotSupported(clazz), MappingGetters.castToUrlNotSupported(clazz), MappingGetters.castToBigDecimalNotSupported(clazz), MappingGetters.castToReaderNotSupported(clazz));
    }

    private static ValueToString valueToString(PrimitiveType id) {
        switch (id) {
            case Bytes: {
                return value -> new String(value.getBytes());
            }
            case Text: {
                return PrimitiveReader::getText;
            }
            case Json: {
                return PrimitiveReader::getJson;
            }
            case JsonDocument: {
                return PrimitiveReader::getJsonDocument;
            }
            case Yson: {
                return value -> new String(value.getYson());
            }
            case Uuid: {
                return value -> String.valueOf(value.getUuid());
            }
            case Bool: {
                return value -> String.valueOf(value.getBool());
            }
            case Int8: {
                return value -> String.valueOf(value.getInt8());
            }
            case Uint8: {
                return value -> String.valueOf(value.getUint8());
            }
            case Int16: {
                return value -> String.valueOf(value.getInt16());
            }
            case Uint16: {
                return value -> String.valueOf(value.getUint16());
            }
            case Int32: {
                return value -> String.valueOf(value.getInt32());
            }
            case Uint32: {
                return value -> String.valueOf(value.getUint32());
            }
            case Int64: {
                return value -> String.valueOf(value.getInt64());
            }
            case Uint64: {
                return value -> String.valueOf(value.getUint64());
            }
            case Float: {
                return value -> String.valueOf(value.getFloat());
            }
            case Double: {
                return value -> String.valueOf(value.getDouble());
            }
            case Date: {
                return value -> String.valueOf(value.getDate());
            }
            case Datetime: {
                return value -> String.valueOf(value.getDatetime());
            }
            case Timestamp: {
                return value -> String.valueOf(value.getTimestamp());
            }
            case Interval: {
                return value -> String.valueOf(value.getInterval());
            }
            case TzDate: {
                return value -> String.valueOf(value.getTzDate());
            }
            case TzDatetime: {
                return value -> String.valueOf(value.getTzDatetime());
            }
            case TzTimestamp: {
                return value -> String.valueOf(value.getTzTimestamp());
            }
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(id, String.class);
        };
    }

    private static ValueToBoolean valueToBoolean(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return PrimitiveReader::getBool;
            }
            case Int8: {
                return value -> value.getInt8() != 0;
            }
            case Uint8: {
                return value -> value.getUint8() != 0;
            }
            case Int16: {
                return value -> value.getInt16() != 0;
            }
            case Uint16: {
                return value -> value.getUint16() != 0;
            }
            case Int32: {
                return value -> value.getInt32() != 0;
            }
            case Uint32: {
                return value -> value.getUint32() != 0L;
            }
            case Int64: {
                return value -> value.getInt64() != 0L;
            }
            case Uint64: {
                return value -> value.getUint64() != 0L;
            }
            case Bytes: {
                return value -> {
                    byte[] stringValue = value.getBytes();
                    if (stringValue.length == 0) {
                        return false;
                    }
                    if (stringValue.length == 1) {
                        if (stringValue[0] == 48) {
                            return false;
                        }
                        if (stringValue[0] == 49) {
                            return true;
                        }
                    }
                    throw MappingGetters.cannotConvert(id, Boolean.TYPE, new String(stringValue));
                };
            }
            case Text: {
                return value -> {
                    String utfValue = value.getText();
                    if (utfValue.isEmpty()) {
                        return false;
                    }
                    if (utfValue.length() == 1) {
                        if (utfValue.charAt(0) == '0') {
                            return false;
                        }
                        if (utfValue.charAt(0) == '1') {
                            return true;
                        }
                    }
                    throw MappingGetters.cannotConvert(id, Boolean.TYPE, utfValue);
                };
            }
        }
        return MappingGetters.castToBooleanNotSupported(id.name());
    }

    private static byte checkByteValue(PrimitiveType id, int value) throws SQLException {
        int ch;
        int n = ch = value >= 0 ? value : ~value;
        if ((ch & 0x7F) != ch) {
            throw MappingGetters.cannotConvert(id, Byte.TYPE, value);
        }
        return (byte)value;
    }

    private static byte checkByteValue(PrimitiveType id, long value) throws SQLException {
        long ch;
        long l = ch = value >= 0L ? value : value ^ 0xFFFFFFFFFFFFFFFFL;
        if ((ch & 0x7FL) != ch) {
            throw MappingGetters.cannotConvert(id, Byte.TYPE, value);
        }
        return (byte)value;
    }

    private static ValueToByte valueToByte(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> MappingGetters.checkByteValue(id, value.getBool() ? 1 : 0);
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Int16: {
                return value -> MappingGetters.checkByteValue(id, value.getInt16());
            }
            case Int32: {
                return value -> MappingGetters.checkByteValue(id, value.getInt32());
            }
            case Int64: {
                return value -> MappingGetters.checkByteValue(id, value.getInt64());
            }
            case Uint8: {
                return value -> MappingGetters.checkByteValue(id, value.getUint8());
            }
            case Uint16: {
                return value -> MappingGetters.checkByteValue(id, value.getUint16());
            }
            case Uint32: {
                return value -> MappingGetters.checkByteValue(id, value.getUint32());
            }
            case Uint64: {
                return value -> MappingGetters.checkByteValue(id, value.getUint64());
            }
        }
        return MappingGetters.castToByteNotSupported(id.name());
    }

    private static short checkShortValue(PrimitiveType id, int value) throws SQLException {
        int ch;
        int n = ch = value >= 0 ? value : ~value;
        if ((ch & Short.MAX_VALUE) != ch) {
            throw MappingGetters.cannotConvert(id, Short.TYPE, value);
        }
        return (short)value;
    }

    private static short checkShortValue(PrimitiveType id, long value) throws SQLException {
        long ch;
        long l = ch = value >= 0L ? value : value ^ 0xFFFFFFFFFFFFFFFFL;
        if ((ch & 0x7FFFL) != ch) {
            throw MappingGetters.cannotConvert(id, Short.TYPE, value);
        }
        return (short)value;
    }

    private static ValueToShort valueToShort(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> MappingGetters.checkShortValue(id, value.getBool() ? 1 : 0);
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Int16: {
                return PrimitiveReader::getInt16;
            }
            case Int32: {
                return value -> MappingGetters.checkShortValue(id, value.getInt32());
            }
            case Int64: {
                return value -> MappingGetters.checkShortValue(id, value.getInt64());
            }
            case Uint8: {
                return value -> MappingGetters.checkShortValue(id, value.getUint8());
            }
            case Uint16: {
                return value -> MappingGetters.checkShortValue(id, value.getUint16());
            }
            case Uint32: {
                return value -> MappingGetters.checkShortValue(id, value.getUint32());
            }
            case Uint64: {
                return value -> MappingGetters.checkShortValue(id, value.getUint64());
            }
        }
        return MappingGetters.castToShortNotSupported(id.name());
    }

    private static int checkIntValue(PrimitiveType id, long value) throws SQLException {
        long ch;
        long l = ch = value >= 0L ? value : value ^ 0xFFFFFFFFFFFFFFFFL;
        if ((ch & Integer.MAX_VALUE) != ch) {
            throw MappingGetters.cannotConvert(id, Integer.TYPE, value);
        }
        return (int)value;
    }

    private static ValueToInt valueToInt(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> value.getBool() ? 1 : 0;
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Int16: {
                return PrimitiveReader::getInt16;
            }
            case Int32: {
                return PrimitiveReader::getInt32;
            }
            case Int64: {
                return value -> MappingGetters.checkIntValue(id, value.getInt64());
            }
            case Uint8: {
                return PrimitiveReader::getUint8;
            }
            case Uint16: {
                return PrimitiveReader::getUint16;
            }
            case Uint32: {
                return value -> MappingGetters.checkIntValue(id, value.getUint32());
            }
            case Uint64: {
                return value -> MappingGetters.checkIntValue(id, value.getUint64());
            }
            case Date: {
                return value -> MappingGetters.checkIntValue(id, value.getDate().toEpochDay());
            }
        }
        return MappingGetters.castToIntNotSupported(id.name());
    }

    private static ValueToLong valueToLong(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> value.getBool() ? 1L : 0L;
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Uint8: {
                return PrimitiveReader::getUint8;
            }
            case Int16: {
                return PrimitiveReader::getInt16;
            }
            case Uint16: {
                return PrimitiveReader::getUint16;
            }
            case Int32: {
                return PrimitiveReader::getInt32;
            }
            case Uint32: {
                return PrimitiveReader::getUint32;
            }
            case Int64: {
                return PrimitiveReader::getInt64;
            }
            case Uint64: {
                return PrimitiveReader::getUint64;
            }
            case Date: {
                return value -> value.getDate().toEpochDay();
            }
            case Datetime: {
                return value -> value.getDatetime().toEpochSecond(ZoneOffset.UTC);
            }
            case Timestamp: {
                return value -> value.getTimestamp().toEpochMilli();
            }
            case TzDate: 
            case TzDatetime: 
            case TzTimestamp: {
                ValueToInstant delegate = MappingGetters.valueToInstant(id);
                return value -> delegate.fromValue(value).toEpochMilli();
            }
            case Interval: {
                return value -> TimeUnit.NANOSECONDS.toMicros(value.getInterval().toNanos());
            }
        }
        return MappingGetters.castToLongNotSupported(id.name());
    }

    private static ValueToFloat valueToFloat(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> value.getBool() ? 1.0f : 0.0f;
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Int16: {
                return PrimitiveReader::getInt16;
            }
            case Int32: {
                return PrimitiveReader::getInt32;
            }
            case Int64: {
                return PrimitiveReader::getInt64;
            }
            case Uint8: {
                return PrimitiveReader::getUint8;
            }
            case Uint16: {
                return PrimitiveReader::getUint16;
            }
            case Uint32: {
                return PrimitiveReader::getUint32;
            }
            case Uint64: {
                return PrimitiveReader::getUint64;
            }
            case Float: {
                return PrimitiveReader::getFloat;
            }
            case Double: {
                return value -> (float)value.getDouble();
            }
        }
        return MappingGetters.castToFloatNotSupported(id.name());
    }

    private static ValueToDouble valueToDouble(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> value.getBool() ? 1.0 : 0.0;
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Uint8: {
                return PrimitiveReader::getUint8;
            }
            case Int16: {
                return PrimitiveReader::getInt16;
            }
            case Uint16: {
                return PrimitiveReader::getUint16;
            }
            case Int32: {
                return PrimitiveReader::getInt32;
            }
            case Uint32: {
                return PrimitiveReader::getUint32;
            }
            case Int64: {
                return PrimitiveReader::getInt64;
            }
            case Uint64: {
                return PrimitiveReader::getUint64;
            }
            case Float: {
                return PrimitiveReader::getFloat;
            }
            case Double: {
                return PrimitiveReader::getDouble;
            }
        }
        return MappingGetters.castToDoubleNotSupported(id.name());
    }

    private static ValueToBytes valueToBytes(PrimitiveType id) {
        switch (id) {
            case Bytes: {
                return PrimitiveReader::getBytes;
            }
            case Text: {
                return value -> value.getText().getBytes();
            }
            case Json: {
                return value -> value.getJson().getBytes();
            }
            case JsonDocument: {
                return value -> value.getJsonDocument().getBytes();
            }
            case Yson: {
                return PrimitiveReader::getYson;
            }
            case Uuid: {
                return value -> value.getUuid().toString().getBytes();
            }
        }
        return MappingGetters.castToBytesNotSupported(id.name());
    }

    private static ValueToInstant valueToInstant(PrimitiveType id) {
        switch (id) {
            case Int64: {
                return v -> Instant.ofEpochMilli(v.getInt64());
            }
            case Uint64: {
                return v -> Instant.ofEpochMilli(v.getUint64());
            }
            case Date: {
                return v -> Instant.ofEpochSecond(v.getDate().toEpochDay() * 24L * 60L * 60L);
            }
            case Datetime: {
                return v -> Instant.ofEpochSecond(v.getDatetime().toEpochSecond(ZoneOffset.UTC));
            }
            case TzDate: {
                return v -> Instant.ofEpochSecond(v.getTzDate().toEpochSecond());
            }
            case TzDatetime: {
                return v -> Instant.ofEpochSecond(v.getTzDatetime().toEpochSecond());
            }
            case Timestamp: {
                return PrimitiveReader::getTimestamp;
            }
            case TzTimestamp: {
                return v -> v.getTzTimestamp().toInstant();
            }
        }
        return MappingGetters.castToInstantNotSupported(id.name());
    }

    private static ValueToNString valueToNString(PrimitiveType id) {
        switch (id) {
            case Bytes: {
                return value -> new String(value.getBytes());
            }
            case Text: {
                return PrimitiveReader::getText;
            }
            case Json: {
                return PrimitiveReader::getJson;
            }
            case JsonDocument: {
                return PrimitiveReader::getJsonDocument;
            }
            case Yson: {
                return value -> new String(value.getYson());
            }
            case Uuid: {
                return value -> String.valueOf(value.getUuid());
            }
        }
        return MappingGetters.castToNStringNotSupported(id.name());
    }

    private static ValueToURL valueToURL(PrimitiveType id) {
        switch (id) {
            case Bytes: {
                return value -> new String(value.getBytes());
            }
            case Text: {
                return PrimitiveReader::getText;
            }
        }
        return MappingGetters.castToUrlNotSupported(id.name());
    }

    private static ValueToBigDecimal valueToBigDecimal(PrimitiveType id) {
        switch (id) {
            case Bool: {
                return value -> BigDecimal.valueOf(value.getBool() ? 1L : 0L);
            }
            case Int8: {
                return value -> BigDecimal.valueOf(value.getInt8());
            }
            case Uint8: {
                return value -> BigDecimal.valueOf(value.getUint8());
            }
            case Int16: {
                return value -> BigDecimal.valueOf(value.getInt16());
            }
            case Uint16: {
                return value -> BigDecimal.valueOf(value.getUint16());
            }
            case Int32: {
                return value -> BigDecimal.valueOf(value.getInt32());
            }
            case Uint32: {
                return value -> BigDecimal.valueOf(value.getUint32());
            }
            case Int64: {
                return value -> BigDecimal.valueOf(value.getInt64());
            }
            case Uint64: {
                return value -> BigDecimal.valueOf(value.getUint64());
            }
            case Float: {
                return value -> BigDecimal.valueOf(value.getFloat());
            }
            case Double: {
                return value -> BigDecimal.valueOf(value.getDouble());
            }
        }
        return MappingGetters.castToBigDecimalNotSupported(id.name());
    }

    private static ValueToReader valueToReader(PrimitiveType id) {
        switch (id) {
            case Bytes: {
                return value -> new InputStreamReader(new ByteArrayInputStream(value.getBytes()));
            }
            case Text: {
                return value -> new StringReader(value.getText());
            }
            case Json: {
                return value -> new StringReader(value.getJson());
            }
            case JsonDocument: {
                return value -> new StringReader(value.getJsonDocument());
            }
            case Yson: {
                return value -> new InputStreamReader(new ByteArrayInputStream(value.getYson()));
            }
            case Uuid: {
                return value -> new StringReader(value.getUuid().toString());
            }
        }
        return MappingGetters.castToReaderNotSupported(id.name());
    }

    private static SqlType buildPrimitiveType(int sqlType, PrimitiveType id) {
        switch (id) {
            case Text: 
            case Json: 
            case JsonDocument: 
            case Uuid: {
                return new SqlType(sqlType, String.class);
            }
            case Bytes: 
            case Yson: {
                return new SqlType(sqlType, byte[].class);
            }
            case Bool: {
                return new SqlType(sqlType, Boolean.class);
            }
            case Int8: {
                return new SqlType(sqlType, Byte.class);
            }
            case Uint8: 
            case Uint16: 
            case Int32: {
                return new SqlType(sqlType, Integer.class);
            }
            case Int16: {
                return new SqlType(sqlType, Short.class);
            }
            case Uint32: 
            case Int64: 
            case Uint64: {
                return new SqlType(sqlType, Long.class);
            }
            case Float: {
                return new SqlType(sqlType, Float.class);
            }
            case Double: {
                return new SqlType(sqlType, Double.class);
            }
            case Date: {
                return new SqlType(sqlType, LocalDate.class);
            }
            case Datetime: {
                return new SqlType(sqlType, LocalDateTime.class);
            }
            case Timestamp: {
                return new SqlType(sqlType, Instant.class);
            }
            case Interval: {
                return new SqlType(sqlType, Duration.class);
            }
            case TzDate: 
            case TzDatetime: 
            case TzTimestamp: {
                return new SqlType(sqlType, ZonedDateTime.class);
            }
        }
        return new SqlType(sqlType, Value.class);
    }

    static SqlType buildDataType(Type type) {
        int sqlType = YdbTypes.toSqlType(type);
        switch (type.getKind()) {
            case PRIMITIVE: {
                return MappingGetters.buildPrimitiveType(sqlType, (PrimitiveType)type);
            }
            case DECIMAL: {
                return new SqlType(sqlType, DecimalValue.class);
            }
        }
        return new SqlType(sqlType, Value.class);
    }

    private static ValueToObject valueToObject(PrimitiveType id) {
        switch (id) {
            case Bytes: {
                return PrimitiveReader::getBytes;
            }
            case Text: {
                return PrimitiveReader::getText;
            }
            case Json: {
                return PrimitiveReader::getJson;
            }
            case JsonDocument: {
                return PrimitiveReader::getJsonDocument;
            }
            case Yson: {
                return PrimitiveReader::getYson;
            }
            case Uuid: {
                return PrimitiveReader::getUuid;
            }
            case Bool: {
                return PrimitiveReader::getBool;
            }
            case Int8: {
                return PrimitiveReader::getInt8;
            }
            case Uint8: {
                return PrimitiveReader::getUint8;
            }
            case Int16: {
                return PrimitiveReader::getInt16;
            }
            case Uint16: {
                return PrimitiveReader::getUint16;
            }
            case Int32: {
                return PrimitiveReader::getInt32;
            }
            case Uint32: {
                return PrimitiveReader::getUint32;
            }
            case Int64: {
                return PrimitiveReader::getInt64;
            }
            case Uint64: {
                return PrimitiveReader::getUint64;
            }
            case Float: {
                return PrimitiveReader::getFloat;
            }
            case Double: {
                return PrimitiveReader::getDouble;
            }
            case Date: {
                return PrimitiveReader::getDate;
            }
            case Datetime: {
                return PrimitiveReader::getDatetime;
            }
            case Timestamp: {
                return PrimitiveReader::getTimestamp;
            }
            case Interval: {
                return PrimitiveReader::getInterval;
            }
            case TzDate: {
                return PrimitiveReader::getTzDate;
            }
            case TzDatetime: {
                return PrimitiveReader::getTzDatetime;
            }
            case TzTimestamp: {
                return PrimitiveReader::getTzTimestamp;
            }
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(id, Object.class);
        };
    }

    private static ValueToClass valueToClass(PrimitiveType id) {
        ValueToClassBuilder builder = new ValueToClassBuilder((Type)id);
        switch (id) {
            case Bytes: {
                return builder.register(byte[].class, PrimitiveReader::getBytes).build();
            }
            case Text: {
                return builder.register(String.class, PrimitiveReader::getText).build();
            }
            case Json: {
                return builder.register(String.class, PrimitiveReader::getJson).build();
            }
            case JsonDocument: {
                return builder.register(String.class, PrimitiveReader::getJsonDocument).build();
            }
            case Yson: {
                return builder.register(byte[].class, PrimitiveReader::getYson).build();
            }
            case Uuid: {
                return builder.register(UUID.class, PrimitiveReader::getUuid).build();
            }
            case Bool: {
                return builder.register(Boolean.TYPE, PrimitiveReader::getBool).register(Boolean.class, PrimitiveReader::getBool).build();
            }
            case Int8: {
                return builder.register(Byte.TYPE, PrimitiveReader::getInt8).register(Byte.class, PrimitiveReader::getInt8).build();
            }
            case Uint8: {
                return builder.register(Integer.TYPE, PrimitiveReader::getUint8).register(Integer.class, PrimitiveReader::getUint8).build();
            }
            case Int16: {
                return builder.register(Short.TYPE, PrimitiveReader::getInt16).register(Short.class, PrimitiveReader::getInt16).build();
            }
            case Uint16: {
                return builder.register(Integer.TYPE, PrimitiveReader::getUint16).register(Integer.class, PrimitiveReader::getUint16).build();
            }
            case Int32: {
                return builder.register(Integer.TYPE, PrimitiveReader::getInt32).register(Integer.class, PrimitiveReader::getInt32).build();
            }
            case Uint32: {
                return builder.register(Long.TYPE, PrimitiveReader::getUint32).register(Long.class, PrimitiveReader::getUint32).build();
            }
            case Int64: {
                return builder.register(Long.TYPE, PrimitiveReader::getInt64).register(Long.class, PrimitiveReader::getInt64).build();
            }
            case Uint64: {
                return builder.register(Long.TYPE, PrimitiveReader::getUint64).register(Long.class, PrimitiveReader::getUint64).build();
            }
            case Float: {
                return builder.register(Float.TYPE, PrimitiveReader::getFloat).register(Float.class, PrimitiveReader::getFloat).build();
            }
            case Double: {
                return builder.register(Double.TYPE, PrimitiveReader::getDouble).register(Double.class, PrimitiveReader::getDouble).build();
            }
            case Date: {
                return builder.register(Long.TYPE, v -> v.getDate().toEpochDay()).register(Long.class, v -> v.getDate().toEpochDay()).register(LocalDate.class, PrimitiveReader::getDate).register(LocalDateTime.class, v -> v.getDate().atStartOfDay()).register(Date.class, v -> Date.valueOf(v.getDate())).register(Timestamp.class, v -> Timestamp.valueOf(v.getDate().atStartOfDay())).register(Instant.class, v -> v.getDate().atStartOfDay(ZoneId.systemDefault()).toInstant()).register(java.util.Date.class, v -> java.util.Date.from(v.getDate().atStartOfDay(ZoneId.systemDefault()).toInstant())).build();
            }
            case Datetime: {
                return builder.register(Long.TYPE, v -> v.getDatetime().toEpochSecond(ZoneOffset.UTC)).register(Long.class, v -> v.getDatetime().toEpochSecond(ZoneOffset.UTC)).register(LocalDate.class, v -> v.getDatetime().toLocalDate()).register(LocalDateTime.class, PrimitiveReader::getDatetime).register(Date.class, v -> Date.valueOf(v.getDatetime().toLocalDate())).register(Timestamp.class, v -> Timestamp.valueOf(v.getDatetime())).register(Instant.class, v -> v.getDatetime().atZone(ZoneId.systemDefault()).toInstant()).register(java.util.Date.class, v -> java.util.Date.from(v.getDatetime().atZone(ZoneId.systemDefault()).toInstant())).build();
            }
            case Timestamp: {
                return builder.register(Long.TYPE, v -> v.getTimestamp().toEpochMilli()).register(Long.class, v -> v.getTimestamp().toEpochMilli()).register(LocalDate.class, v -> v.getTimestamp().atZone(ZoneId.systemDefault()).toLocalDate()).register(LocalDateTime.class, v -> v.getTimestamp().atZone(ZoneId.systemDefault()).toLocalDateTime()).register(Date.class, v -> Date.valueOf(v.getTimestamp().atZone(ZoneId.systemDefault()).toLocalDate())).register(Timestamp.class, v -> Timestamp.valueOf(v.getTimestamp().atZone(ZoneId.systemDefault()).toLocalDateTime())).register(Instant.class, PrimitiveReader::getTimestamp).register(java.util.Date.class, v -> java.util.Date.from(v.getTimestamp())).build();
            }
            case Interval: {
                return builder.register(Duration.class, PrimitiveReader::getInterval).build();
            }
            case TzDate: {
                return builder.register(ZonedDateTime.class, PrimitiveReader::getTzDate).build();
            }
            case TzDatetime: {
                return builder.register(ZonedDateTime.class, PrimitiveReader::getTzDatetime).build();
            }
            case TzTimestamp: {
                return builder.register(ZonedDateTime.class, PrimitiveReader::getTzTimestamp).build();
            }
        }
        return MappingGetters.castToClassNotSupported(id.toString());
    }

    private static SQLException cannotConvert(PrimitiveType type, Class<?> javaType, Object value) {
        return new SQLException(String.format("Cannot cast [%s] with value [%s] to [%s]", type, value, javaType));
    }

    private static SQLException dataTypeNotSupported(PrimitiveType type, Class<?> javaType) {
        return new SQLException(String.format("Cannot cast [%s] to [%s]", type, javaType));
    }

    private static ValueToBoolean castToBooleanNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Boolean.TYPE));
        };
    }

    private static ValueToByte castToByteNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Byte.TYPE));
        };
    }

    private static ValueToShort castToShortNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Short.TYPE));
        };
    }

    private static ValueToInt castToIntNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Integer.TYPE));
        };
    }

    private static ValueToLong castToLongNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Long.TYPE));
        };
    }

    private static ValueToFloat castToFloatNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Float.TYPE));
        };
    }

    private static ValueToDouble castToDoubleNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Double.TYPE));
        };
    }

    private static ValueToBytes castToBytesNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, byte[].class));
        };
    }

    private static ValueToInstant castToInstantNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Long.TYPE));
        };
    }

    private static ValueToNString castToNStringNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, String.class));
        };
    }

    private static ValueToURL castToUrlNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, URL.class));
        };
    }

    private static ValueToBigDecimal castToBigDecimalNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, BigDecimal.class));
        };
    }

    private static ValueToReader castToReaderNotSupported(String type) {
        return value -> {
            throw new SQLException(String.format("Cannot cast [%s] to [%s]", type, Reader.class));
        };
    }

    private static ValueToClass castToClassNotSupported(final String type) {
        return new ValueToClass(){

            @Override
            public <T> T fromValue(ValueReader reader, Class<T> clazz) throws SQLException {
                throw new SQLException(String.format("Cannot cast [%s] to class [%s]", type, clazz));
            }
        };
    }

    public static class SqlType {
        private final int sqlType;
        private final Class<?> javaType;

        SqlType(int sqlType, Class<?> javaType) {
            this.sqlType = sqlType;
            this.javaType = Objects.requireNonNull(javaType);
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }
    }

    private static interface ValueToReader {
        public Reader fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToBigDecimal {
        public BigDecimal fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToURL {
        public String fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToNString {
        public String fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToInstant {
        public Instant fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToClass {
        public <T> T fromValue(ValueReader var1, Class<T> var2) throws SQLException;
    }

    private static interface ValueToObject {
        public Object fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToBytes {
        public byte[] fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToDouble {
        public double fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToFloat {
        public float fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToLong {
        public long fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToInt {
        public int fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToShort {
        public short fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToByte {
        public byte fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToBoolean {
        public boolean fromValue(ValueReader var1) throws SQLException;
    }

    private static interface ValueToString {
        public String fromValue(ValueReader var1) throws SQLException;
    }

    public static class Getters {
        private final ValueToString toString;
        private final ValueToBoolean toBoolean;
        private final ValueToByte toByte;
        private final ValueToShort toShort;
        private final ValueToInt toInt;
        private final ValueToLong toLong;
        private final ValueToFloat toFloat;
        private final ValueToDouble toDouble;
        private final ValueToBytes toBytes;
        private final ValueToObject toObject;
        private final ValueToClass toClass;
        private final ValueToInstant toInstant;
        private final ValueToNString toNString;
        private final ValueToURL toURL;
        private final ValueToBigDecimal toBigDecimal;
        private final ValueToReader toReader;

        Getters(ValueToString toString, ValueToBoolean toBoolean, ValueToByte toByte, ValueToShort toShort, ValueToInt toInt, ValueToLong toLong, ValueToFloat toFloat, ValueToDouble toDouble, ValueToBytes toBytes, ValueToObject toObject, ValueToClass toClass, ValueToInstant toInstant, ValueToNString toNString, ValueToURL toURL, ValueToBigDecimal toBigDecimal, ValueToReader toReader) {
            this.toString = toString;
            this.toBoolean = toBoolean;
            this.toByte = toByte;
            this.toShort = toShort;
            this.toInt = toInt;
            this.toLong = toLong;
            this.toFloat = toFloat;
            this.toDouble = toDouble;
            this.toBytes = toBytes;
            this.toObject = toObject;
            this.toClass = toClass;
            this.toInstant = toInstant;
            this.toNString = toNString;
            this.toURL = toURL;
            this.toBigDecimal = toBigDecimal;
            this.toReader = toReader;
        }

        public String readString(ValueReader reader) throws SQLException {
            return this.toString.fromValue(reader);
        }

        public boolean readBoolean(ValueReader reader) throws SQLException {
            return this.toBoolean.fromValue(reader);
        }

        public byte readByte(ValueReader reader) throws SQLException {
            return this.toByte.fromValue(reader);
        }

        public short readShort(ValueReader reader) throws SQLException {
            return this.toShort.fromValue(reader);
        }

        public int readInt(ValueReader reader) throws SQLException {
            return this.toInt.fromValue(reader);
        }

        public long readLong(ValueReader reader) throws SQLException {
            return this.toLong.fromValue(reader);
        }

        public float readFloat(ValueReader reader) throws SQLException {
            return this.toFloat.fromValue(reader);
        }

        public double readDouble(ValueReader reader) throws SQLException {
            return this.toDouble.fromValue(reader);
        }

        public byte[] readBytes(ValueReader reader) throws SQLException {
            return this.toBytes.fromValue(reader);
        }

        public Object readObject(ValueReader reader) throws SQLException {
            return this.toObject.fromValue(reader);
        }

        public <T> T readClass(ValueReader reader, Class<T> clazz) throws SQLException {
            return this.toClass.fromValue(reader, clazz);
        }

        public Instant readInstant(ValueReader reader) throws SQLException {
            return this.toInstant.fromValue(reader);
        }

        public String readNString(ValueReader reader) throws SQLException {
            return this.toNString.fromValue(reader);
        }

        public String readURL(ValueReader reader) throws SQLException {
            return this.toURL.fromValue(reader);
        }

        public BigDecimal readBigDecimal(ValueReader reader) throws SQLException {
            return this.toBigDecimal.fromValue(reader);
        }

        public Reader readReader(ValueReader reader) throws SQLException {
            return this.toReader.fromValue(reader);
        }
    }

    private static class ValueToClassBuilder {
        private final Type type;
        private final Map<Class<?>, Function<ValueReader, ?>> map = new HashMap();

        ValueToClassBuilder(Type type) {
            this.type = type;
        }

        public <T> ValueToClassBuilder register(Class<T> clazz, Function<ValueReader, T> func) {
            this.map.put(clazz, func);
            return this;
        }

        public ValueToClass build() {
            return new ValueToClass(){

                @Override
                public <T> T fromValue(ValueReader reader, Class<T> clazz) throws SQLException {
                    Function f = (Function)map.get(clazz);
                    if (f != null) {
                        return (T)f.apply(reader);
                    }
                    throw new SQLException(String.format("Cannot cast [%s] to class [%s]", type, clazz));
                }
            };
        }
    }
}

