/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.impl.YdbTypes;
import tech.ydb.jdbc.query.ParamDescription;
import tech.ydb.jdbc.query.YdbPreparedQuery;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.query.params.ValueFactory;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class InMemoryQuery
implements YdbPreparedQuery {
    private final String yql;
    private final boolean isAutoDeclare;
    private final ParamDescription[] parameters;
    private final Map<String, ParamDescription> parametersByName;
    private final Map<String, Value<?>> paramValues;
    private final List<Params> batchList;

    public InMemoryQuery(YdbQuery query, boolean isAutoDeclare) {
        this.yql = query.getPreparedYql();
        this.isAutoDeclare = isAutoDeclare;
        this.parameters = (ParamDescription[])query.getStatements().stream().flatMap(s -> s.getParams().stream()).toArray(ParamDescription[]::new);
        this.parametersByName = query.getStatements().stream().flatMap(s -> s.getParams().stream()).collect(Collectors.toMap(ParamDescription::name, Function.identity()));
        this.paramValues = new HashMap();
        this.batchList = new ArrayList<Params>();
    }

    @Override
    public String getQueryText(Params prms) throws SQLException {
        if (!this.isAutoDeclare) {
            return this.yql;
        }
        StringBuilder query = new StringBuilder();
        Map values = prms.values();
        for (ParamDescription prm : this.parameters) {
            if (!values.containsKey(prm.name())) {
                throw new SQLDataException("Missing value for parameter: " + prm.name());
            }
            String prmType = ((Value)values.get(prm.name())).getType().toString();
            query.append("DECLARE ").append(prm.name()).append(" AS ").append(prmType).append(";\n");
        }
        query.append(this.yql);
        return query.toString();
    }

    @Override
    public int parametersCount() {
        return this.paramValues.size();
    }

    @Override
    public int batchSize() {
        return this.batchList.size();
    }

    @Override
    public void addBatch() {
        this.batchList.add(Params.copyOf(this.paramValues));
        this.paramValues.clear();
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public void clearParameters() {
        this.paramValues.clear();
    }

    @Override
    public List<Params> getBatchParams() {
        return this.batchList;
    }

    @Override
    public Params getCurrentParams() {
        return Params.copyOf(this.paramValues);
    }

    @Override
    public String getNameByIndex(int index) throws SQLException {
        if (index <= 0 || index > this.parameters.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.parameters[index - 1].name();
    }

    @Override
    public TypeDescription getDescription(int index) throws SQLException {
        if (index <= 0 || index > this.parameters.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        ParamDescription p = this.parameters[index - 1];
        if (p.type() != null) {
            return p.type();
        }
        Value<?> arg = this.paramValues.get(p.name());
        if (arg != null) {
            return TypeDescription.of(arg.getType());
        }
        return null;
    }

    @Override
    public void setParam(int index, Object obj, int sqlType) throws SQLException {
        if (index <= 0 || index > this.parameters.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        this.setParam(this.parameters[index - 1], obj, sqlType);
    }

    @Override
    public void setParam(String name, Object obj, int sqlType) throws SQLException {
        ParamDescription param = this.parametersByName.get(name);
        if (param == null) {
            param = new ParamDescription(name, null);
        }
        this.setParam(param, obj, sqlType);
    }

    private void setParam(ParamDescription param, Object obj, int sqlType) throws SQLException {
        if (obj instanceof Value) {
            this.paramValues.put(param.name(), (Value)obj);
            return;
        }
        TypeDescription description = param.type();
        if (description == null) {
            Type type = YdbTypes.findType(obj, sqlType);
            if (type == null) {
                throw new SQLException(String.format("Unable to convert sqlType %s to YDB type for parameter: %s", sqlType, obj));
            }
            description = TypeDescription.of(type);
        }
        this.paramValues.put(param.name(), ValueFactory.readValue(param.name(), obj, description));
    }
}

