/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.util.ArrayList;
import java.util.List;

public class YqlBatcher {
    private State state = State.INIT;
    private Cmd cmd = null;
    private String tableName = null;
    private final List<String> columns = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();

    public boolean isInsert() {
        return this.cmd == Cmd.INSERT;
    }

    public boolean isUpsert() {
        return this.cmd == Cmd.UPSERT;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean isValidBatch() {
        return this.state == State.VALUES_CLOSE_PAREN && this.cmd != null && this.tableName != null && !this.tableName.isEmpty() && !this.columns.isEmpty() && this.columns.size() == this.values.size();
    }

    public void readInsert() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.INSERT;
            return;
        }
        this.state = State.ERROR;
    }

    public void readUpsert() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.UPSERT;
            return;
        }
        this.state = State.ERROR;
    }

    public void readOpenParen() {
        if (this.state == State.TABLE_NAME) {
            this.state = State.COLUMNS_OPEN_PAREN_OR_COMMA;
            return;
        }
        if (this.state == State.VALUES) {
            this.state = State.VALUES_OPEN_PAREN_OR_COMMA;
            return;
        }
        this.state = State.ERROR;
    }

    public void readCloseParen() {
        if (this.state == State.COLUMN_NAME) {
            this.state = State.COLUMNS_CLOSE_PAREN;
            return;
        }
        if (this.state == State.COLUMN_VALUE) {
            this.state = State.VALUES_CLOSE_PAREN;
            return;
        }
        this.state = State.ERROR;
    }

    public void readComma() {
        if (this.state == State.COLUMN_NAME) {
            this.state = State.COLUMNS_OPEN_PAREN_OR_COMMA;
            return;
        }
        if (this.state == State.COLUMN_VALUE) {
            this.state = State.VALUES_OPEN_PAREN_OR_COMMA;
            return;
        }
        this.state = State.ERROR;
    }

    public void readSemiColon() {
        if (this.state == State.INIT || this.state == State.VALUES_CLOSE_PAREN) {
            return;
        }
        this.state = State.ERROR;
    }

    public void readParameter() {
        if (this.state == State.VALUES_OPEN_PAREN_OR_COMMA) {
            this.values.add("?");
            this.state = State.COLUMN_VALUE;
            return;
        }
        this.state = State.ERROR;
    }

    public void readSingleQuoteLiteral(char[] query, int start, int length) {
        this.state = State.ERROR;
    }

    public void readDoubleQuoteLiteral(char[] query, int start, int length) {
        this.state = State.ERROR;
    }

    public void readIdentifier(char[] query, int start, int length) {
        if (this.state == State.CMD && length == 4 && (query[start] | 0x20) == 105 && (query[start + 1] | 0x20) == 110 && (query[start + 2] | 0x20) == 116 && (query[start + 3] | 0x20) == 111) {
            this.state = State.INTO;
            return;
        }
        if (this.state == State.COLUMNS_CLOSE_PAREN && length == 6 && (query[start] | 0x20) == 118 && (query[start + 1] | 0x20) == 97 && (query[start + 2] | 0x20) == 108 && (query[start + 3] | 0x20) == 117 && (query[start + 4] | 0x20) == 101 && (query[start + 5] | 0x20) == 115) {
            this.state = State.VALUES;
            return;
        }
        if (this.state == State.INTO) {
            this.tableName = this.unquote(query, start, length);
            this.state = State.TABLE_NAME;
            return;
        }
        if (this.state == State.COLUMNS_OPEN_PAREN_OR_COMMA) {
            this.columns.add(this.unquote(query, start, length));
            this.state = State.COLUMN_NAME;
            return;
        }
        this.state = State.ERROR;
    }

    private String unquote(char[] chars, int start, int length) {
        if (chars[start] == '`' && chars[start + length - 1] == '`') {
            return String.valueOf(chars, start + 1, length - 2);
        }
        return String.valueOf(chars, start, length);
    }

    private static enum State {
        INIT,
        CMD,
        INTO,
        TABLE_NAME,
        COLUMNS_OPEN_PAREN_OR_COMMA,
        COLUMN_NAME,
        COLUMNS_CLOSE_PAREN,
        VALUES,
        VALUES_OPEN_PAREN_OR_COMMA,
        COLUMN_VALUE,
        VALUES_CLOSE_PAREN,
        ERROR;

    }

    private static enum Cmd {
        UPSERT,
        INSERT;

    }
}

