/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.QueryCmd;
import tech.ydb.jdbc.query.QueryStatement;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YqlBatcher;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;

public class YdbQueryParser {
    private final boolean isDetectQueryType;
    private final boolean isDetectJdbcParameters;
    private final List<QueryStatement> statements = new ArrayList<QueryStatement>();
    private final YqlBatcher batcher = new YqlBatcher();

    public YdbQueryParser(boolean isDetectQueryType, boolean isDetectJdbcParameters) {
        this.isDetectQueryType = isDetectQueryType;
        this.isDetectJdbcParameters = isDetectJdbcParameters;
    }

    public List<QueryStatement> getStatements() {
        return this.statements;
    }

    public YqlBatcher getYqlBatcher() {
        return this.batcher;
    }

    public QueryType detectQueryType() throws SQLException {
        QueryType type = null;
        for (QueryStatement st : this.statements) {
            if (st.getType() == QueryType.UNKNOWN) continue;
            if (type == null) {
                type = st.getType();
                continue;
            }
            if (type == st.getType()) continue;
            String msg = "Query cannot contain expressions with different types: " + (Object)((Object)type) + ", " + (Object)((Object)st.getType());
            throw new SQLFeatureNotSupportedException(msg);
        }
        return type != null ? type : QueryType.DATA_QUERY;
    }

    public String parseSQL(String origin) throws SQLException {
        int fragmentStart = 0;
        boolean detectJdbcArgs = false;
        QueryStatement statement = null;
        QueryType type = null;
        int parenLevel = 0;
        int keywordStart = -1;
        boolean lastKeywordIsOffsetLimit = false;
        char[] chars = origin.toCharArray();
        StringBuilder parsed = new StringBuilder(origin.length() + 10);
        ArgNameGenerator argNameGenerator = new ArgNameGenerator();
        block14: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            boolean isInsideKeyword = false;
            int keywordEnd = i;
            switch (ch) {
                case '\'': {
                    int singleQuitesEnd = YdbQueryParser.parseSingleQuotes(chars, i);
                    this.batcher.readSingleQuoteLiteral(chars, i, singleQuitesEnd - i + 1);
                    i = singleQuitesEnd;
                    break;
                }
                case '\"': {
                    int doubleQuitesEnd = YdbQueryParser.parseDoubleQuotes(chars, i);
                    this.batcher.readDoubleQuoteLiteral(chars, i, doubleQuitesEnd - i + 1);
                    i = doubleQuitesEnd;
                    break;
                }
                case '`': {
                    int backstickQuitesEnd = YdbQueryParser.parseBacktickQuotes(chars, i);
                    this.batcher.readIdentifier(chars, i, backstickQuitesEnd - i + 1);
                    i = backstickQuitesEnd;
                    break;
                }
                case '-': {
                    i = YdbQueryParser.parseLineComment(chars, i);
                    break;
                }
                case '/': {
                    i = YdbQueryParser.parseBlockComment(chars, i);
                    break;
                }
                case '?': {
                    if (!detectJdbcArgs || statement == null) break;
                    parsed.append(chars, fragmentStart, i - fragmentStart);
                    if (i + 1 < chars.length && chars[i + 1] == '?') {
                        parsed.append('?');
                        this.batcher.readIdentifier(chars, i, 1);
                        ++i;
                    } else {
                        String binded = argNameGenerator.createArgName(origin);
                        TypeDescription forcedType = lastKeywordIsOffsetLimit ? TypeDescription.of((Type)PrimitiveType.Uint64) : null;
                        statement.addParameter(binded, forcedType);
                        parsed.append(binded);
                        this.batcher.readParameter();
                    }
                    fragmentStart = i + 1;
                    break;
                }
                default: {
                    if (keywordStart >= 0) {
                        isInsideKeyword = Character.isJavaIdentifierPart(ch);
                        break;
                    }
                    isInsideKeyword = Character.isJavaIdentifierStart(ch);
                    if (!isInsideKeyword) break;
                    keywordStart = i;
                }
            }
            if (!(keywordStart < 0 || isInsideKeyword && i != chars.length - 1)) {
                lastKeywordIsOffsetLimit = false;
                int keywordLength = (isInsideKeyword ? i + 1 : keywordEnd) - keywordStart;
                if (statement != null) {
                    this.batcher.readIdentifier(chars, keywordStart, keywordLength);
                    if (parenLevel == 0 && YdbQueryParser.parseReturningKeyword(chars, keywordStart)) {
                        statement.setHasReturning(true);
                    }
                    if (YdbQueryParser.parseOffsetKeyword(chars, keywordStart) || YdbQueryParser.parseLimitKeyword(chars, keywordStart)) {
                        lastKeywordIsOffsetLimit = true;
                    }
                } else {
                    boolean skipped = false;
                    if (this.isDetectQueryType) {
                        if (YdbQueryParser.parseScanKeyword(chars, keywordStart)) {
                            type = QueryType.SCAN_QUERY;
                            parsed.append(chars, fragmentStart, keywordStart - fragmentStart);
                            fragmentStart = isInsideKeyword ? keywordEnd + 1 : keywordEnd;
                            skipped = true;
                        }
                        if (YdbQueryParser.parseExplainKeyword(chars, keywordStart)) {
                            type = QueryType.EXPLAIN_QUERY;
                            parsed.append(chars, fragmentStart, keywordStart - fragmentStart);
                            fragmentStart = isInsideKeyword ? keywordEnd + 1 : keywordEnd;
                            skipped = true;
                        }
                        if (YdbQueryParser.parseBulkKeyword(chars, keywordStart)) {
                            type = QueryType.BULK_QUERY;
                            parsed.append(chars, fragmentStart, keywordStart - fragmentStart);
                            fragmentStart = isInsideKeyword ? keywordEnd + 1 : keywordEnd;
                            skipped = true;
                        }
                    }
                    if (!skipped) {
                        statement = new QueryStatement(type, QueryType.UNKNOWN, QueryCmd.UNKNOWN);
                        if (YdbQueryParser.parseSelectKeyword(chars, keywordStart)) {
                            statement = new QueryStatement(type, QueryType.DATA_QUERY, QueryCmd.SELECT);
                            this.batcher.readIdentifier(chars, keywordStart, keywordLength);
                        }
                        if (YdbQueryParser.parseInsertKeyword(chars, keywordStart)) {
                            statement = new QueryStatement(type, QueryType.DATA_QUERY, QueryCmd.INSERT_UPSERT);
                            this.batcher.readInsert();
                        }
                        if (YdbQueryParser.parseUpsertKeyword(chars, keywordStart)) {
                            statement = new QueryStatement(type, QueryType.DATA_QUERY, QueryCmd.INSERT_UPSERT);
                            this.batcher.readUpsert();
                        }
                        if (YdbQueryParser.parseUpdateKeyword(chars, keywordStart) || YdbQueryParser.parseDeleteKeyword(chars, keywordStart) || YdbQueryParser.parseReplaceKeyword(chars, keywordStart)) {
                            statement = new QueryStatement(type, QueryType.DATA_QUERY, QueryCmd.UPDATE_REPLACE_DELETE);
                            this.batcher.readIdentifier(chars, keywordStart, keywordLength);
                        }
                        if (YdbQueryParser.parseAlterKeyword(chars, keywordStart) || YdbQueryParser.parseCreateKeyword(chars, keywordStart) || YdbQueryParser.parseDropKeyword(chars, keywordStart)) {
                            statement = new QueryStatement(type, QueryType.SCHEME_QUERY, QueryCmd.CREATE_ALTER_DROP);
                            this.batcher.readIdentifier(chars, keywordStart, keywordLength);
                        }
                        this.statements.add(statement);
                        detectJdbcArgs = statement.getType() != QueryType.SCHEME_QUERY && statement.getType() != QueryType.UNKNOWN && this.isDetectJdbcParameters;
                    }
                }
                keywordStart = -1;
            }
            switch (ch) {
                case '(': {
                    ++parenLevel;
                    this.batcher.readOpenParen();
                    continue block14;
                }
                case ')': {
                    --parenLevel;
                    this.batcher.readCloseParen();
                    continue block14;
                }
                case ',': {
                    this.batcher.readComma();
                    continue block14;
                }
                case ';': {
                    this.batcher.readSemiColon();
                    if (parenLevel != 0) continue block14;
                    statement = null;
                    type = null;
                    detectJdbcArgs = false;
                    continue block14;
                }
            }
        }
        if (fragmentStart < chars.length) {
            parsed.append(chars, fragmentStart, chars.length - fragmentStart);
        }
        return parsed.toString();
    }

    private static int parseSingleQuotes(char[] query, int offset) {
        block4: while (++offset < query.length) {
            switch (query[offset]) {
                case '\\': {
                    ++offset;
                    continue block4;
                }
                case '\'': {
                    return offset;
                }
            }
        }
        return query.length;
    }

    private static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    private static int parseBacktickQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '`') {
        }
        return offset;
    }

    private static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (offset + 1 < query.length && query[++offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    private static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    private static boolean parseAlterKeyword(char[] query, int offset) {
        if (query.length < offset + 5) {
            return false;
        }
        return (query[offset] | 0x20) == 97 && (query[offset + 1] | 0x20) == 108 && (query[offset + 2] | 0x20) == 116 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114;
    }

    private static boolean parseCreateKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 99 && (query[offset + 1] | 0x20) == 114 && (query[offset + 2] | 0x20) == 101 && (query[offset + 3] | 0x20) == 97 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    private static boolean parseDropKeyword(char[] query, int offset) {
        if (query.length < offset + 4) {
            return false;
        }
        return (query[offset] | 0x20) == 100 && (query[offset + 1] | 0x20) == 114 && (query[offset + 2] | 0x20) == 111 && (query[offset + 3] | 0x20) == 112;
    }

    private static boolean parseScanKeyword(char[] query, int offset) {
        if (query.length < offset + 4) {
            return false;
        }
        return (query[offset] | 0x20) == 115 && (query[offset + 1] | 0x20) == 99 && (query[offset + 2] | 0x20) == 97 && (query[offset + 3] | 0x20) == 110;
    }

    private static boolean parseBulkKeyword(char[] query, int offset) {
        if (query.length < offset + 4) {
            return false;
        }
        return (query[offset] | 0x20) == 98 && (query[offset + 1] | 0x20) == 117 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 107;
    }

    private static boolean parseExplainKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 101 && (query[offset + 1] | 0x20) == 120 && (query[offset + 2] | 0x20) == 112 && (query[offset + 3] | 0x20) == 108 && (query[offset + 4] | 0x20) == 97 && (query[offset + 5] | 0x20) == 105 && (query[offset + 6] | 0x20) == 110;
    }

    private static boolean parseSelectKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 115 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 99 && (query[offset + 5] | 0x20) == 116;
    }

    private static boolean parseUpdateKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 117 && (query[offset + 1] | 0x20) == 112 && (query[offset + 2] | 0x20) == 100 && (query[offset + 3] | 0x20) == 97 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    private static boolean parseUpsertKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 117 && (query[offset + 1] | 0x20) == 112 && (query[offset + 2] | 0x20) == 115 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 116;
    }

    private static boolean parseInsertKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 105 && (query[offset + 1] | 0x20) == 110 && (query[offset + 2] | 0x20) == 115 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 116;
    }

    private static boolean parseDeleteKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 100 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    private static boolean parseReplaceKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 114 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 112 && (query[offset + 3] | 0x20) == 108 && (query[offset + 4] | 0x20) == 97 && (query[offset + 5] | 0x20) == 99 && (query[offset + 6] | 0x20) == 101;
    }

    private static boolean parseReturningKeyword(char[] query, int offset) {
        if (query.length < offset + 9) {
            return false;
        }
        return (query[offset] | 0x20) == 114 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 116 && (query[offset + 3] | 0x20) == 117 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 110 && (query[offset + 6] | 0x20) == 105 && (query[offset + 7] | 0x20) == 110 && (query[offset + 8] | 0x20) == 103;
    }

    private static boolean parseOffsetKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 111 && (query[offset + 1] | 0x20) == 102 && (query[offset + 2] | 0x20) == 102 && (query[offset + 3] | 0x20) == 115 && (query[offset + 4] | 0x20) == 101 && (query[offset + 5] | 0x20) == 116;
    }

    private static boolean parseLimitKeyword(char[] query, int offset) {
        if (query.length < offset + 5) {
            return false;
        }
        return (query[offset] | 0x20) == 108 && (query[offset + 1] | 0x20) == 105 && (query[offset + 2] | 0x20) == 109 && (query[offset + 3] | 0x20) == 105 && (query[offset + 4] | 0x20) == 116;
    }

    private static class ArgNameGenerator {
        private int index = 0;

        private ArgNameGenerator() {
        }

        public String createArgName(String origin) {
            String name;
            do {
                ++this.index;
            } while (origin.contains(name = "$jp" + this.index));
            return name;
        }
    }
}

