/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.time.Duration;
import java.util.concurrent.LinkedBlockingQueue;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbExecutor;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.table.SessionRetryContext;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.impl.ProtoValueReaders;
import tech.ydb.table.settings.ExecuteScanQuerySettings;
import tech.ydb.table.settings.ExecuteSchemeQuerySettings;
import tech.ydb.table.values.ListValue;

public abstract class BaseYdbExecutor
implements YdbExecutor {
    private final SessionRetryContext retryCtx;

    public BaseYdbExecutor(YdbContext ctx) {
        this.retryCtx = ctx.getRetryCtx();
    }

    @Override
    public void executeSchemeQuery(YdbContext ctx, YdbValidator validator, String yql) throws SQLException {
        this.ensureOpened();
        ExecuteSchemeQuerySettings settings = ctx.withDefaultTimeout(new ExecuteSchemeQuerySettings());
        validator.execute((Object)((Object)QueryType.SCHEME_QUERY) + " >>\n" + yql, () -> this.retryCtx.supplyStatus(session -> session.executeSchemeQuery(yql, settings)));
    }

    @Override
    public void executeBulkUpsert(YdbContext ctx, YdbValidator validator, String yql, String tablePath, ListValue rows) throws SQLException {
        this.ensureOpened();
        validator.execute((Object)((Object)QueryType.BULK_QUERY) + " >>\n" + yql, () -> this.retryCtx.supplyStatus(session -> session.executeBulkUpsert(tablePath, rows)));
    }

    @Override
    public ResultSetReader executeScanQuery(YdbContext ctx, YdbValidator validator, YdbQuery query, String yql, Params params) throws SQLException {
        this.ensureOpened();
        LinkedBlockingQueue resultSets = new LinkedBlockingQueue();
        Duration scanQueryTimeout = ctx.getOperationProperties().getScanQueryTimeout();
        ExecuteScanQuerySettings settings = ((ExecuteScanQuerySettings.Builder)ExecuteScanQuerySettings.newBuilder().withRequestTimeout(scanQueryTimeout)).build();
        ctx.traceQuery(query, yql);
        validator.execute((Object)((Object)QueryType.SCAN_QUERY) + " >>\n" + yql, () -> this.retryCtx.supplyStatus(session -> {
            resultSets.clear();
            return session.executeScanQuery(yql, params, settings).start(resultSets::add);
        }));
        return ProtoValueReaders.forResultSets(resultSets);
    }
}

